// $Id: JGTrace.h,v 1.5 2003/07/27 13:27:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTrace.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGTRACE_H
#define JGTRACE_H

#include "jyugem/gem/gembase.h"
#include "jyugem/gem/JGNameInfo.h"
#include "jyugem/gem/JGVariable.h"

class BS2Message;
class JGTraceManager;

// Define an object to hold configure data
class JGTrace : public JGNameInfo, ACE_Handler
{
    friend class JGTraceManager;
    friend class HSTraceManager;

public:
    JGTrace() : ACE_Handler(), JGNameInfo(), m_dsper(_TX("")), m_totsmp(0),
                m_repgsz(0), m_cursmp(0), m_stime(ACE_OS::gettimeofday())
    {
        TRACE_FUNCTION(TRL_CONSTRUCT, "JGTrace::JGTrace");
    }
    JGTrace(const JGid& id, int totsmp, int repgsz, const string& dsper)
        : ACE_Handler(), JGNameInfo(), m_dsper(dsper), m_totsmp(totsmp),
          m_repgsz(repgsz), m_cursmp(0), m_stime(ACE_OS::gettimeofday())
    {
        TRACE_FUNCTION(TRL_CONSTRUCT, "JGTrace::JGTrace");
        m_id = id;
        m_id.get(m_name);
    }
    virtual ~JGTrace()
    {
        TRACE_FUNCTION(TRL_CONSTRUCT, "JGTrace::~JGTrace");
    }
    virtual void  printOn(string& buf, int mode = 0);

    virtual void handle_time_out(const ACE_Time_Value &tv,
                                 const void *arg);

    JGTrace& operator=(const JGTrace& rhs);
    void insert(JGVariable * var) { m_vars.push_back(var); }

    JGid&  trid()               { return m_id; }
    void   trid(const JGid& id) { m_id = id;  m_id.get(m_name); }
    void   totsmp(int totsmp)   { m_totsmp = totsmp; }
    int    totsmp() const       { return m_totsmp; }
    void   repgsz(int repgsz)   { m_repgsz = repgsz; }
    void   dsper(const string& dsper) { m_dsper = dsper; }
    void   dir(const string& dir)     { m_dir = dir; }
    void   active(bool tf) { m_active = tf; }
    bool   active()        { return m_active; }
    void   manager(JGTraceManager * mngr) { m_manager = mngr; }
    int    varSize()    { return m_vars.size(); }
    JGVariables& vars() { return m_vars; }

    void convertime();              // DSPER: string to TimeValue
    void sampling();                // Sampling variables of trace
    BS2Message * create();          // Create SECS Message (S6F1)
    BS2Item * makeInitItem();       // Make SECS Message Item (S2F23)

protected:
    string m_dsper;
    int    m_totsmp;
    int    m_repgsz;
    JGVariables m_vars;
    bool   m_active;
    string m_dir;                   // trace data saved that stores directory
    //
    JGTraceManager * m_manager;
    u_long  m_cursmp;               // current sampling count (SMPLN)
    long    m_tmid;                 // timer id
    ACE_Time_Value m_dspertv;
    ACE_Time_Value m_stime;
    vector<JGvalue> m_values;       // sampled data list

};

typedef map<JGid, JGTrace, id_less, allocator<JGTrace> > JGTraceTable;
typedef JGTraceTable::value_type  JGTracePair;
typedef list<JGTrace *> JGTraces;
typedef list<JGTrace>   JGTraceList;

#endif  /* JGTRACE_H */
