// $Id: JGTimeModule.h,v 1.6 2003/02/26 13:26:02 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGTimeModule.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGTIMEMODULE_H
#define JGTIMEMODULE_H

#include "jyugem/gem/JGManager.h"
#include "jyugem/gem/JGTriggerInfo.h"

// Forward declaration
class BS2Message;
class BS2Item;

//-----------------------------------------------------------------------------
//
// Time Module
//
//-----------------------------------------------------------------------------
class BEE_Export JGTimeModule : public JGManager
{
    friend class PollingTimerHandler;
public:
    JGTimeModule(bool usingNetTime = false);
    ~JGTimeModule();

    virtual int init(void * parm = 0);
    virtual int open(void * = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * evtptr, BS2Message * msg);

    // Timestamp Format (0 = 12chars. 0 <> 16chars.)
    int  getTimestampFormat();
    void setTimestampFormat(int fmt) { m_timeformat = fmt; }

    // Date and Time
    bool supportsChangingDateAndTime() { return m_changingTime; }
    void getDateAndTime(string& time);
    void setDateAndTime(const BCHAR * time);

    void getSystemClock(string& time);

    // Formatted Date and Time
    string clock();
    void getFormattedDateAndTime(string& time);
    void setFormattedDateAndTime(const BCHAR * time);

    //
    int changeClock(BS2Message * msg);
    BS2Message * setDateAndTime(BS2Message * msg);  // for S2F31
    BS2Message * getClock(BS2Message * msg);        // for S2F17

    BS2Message * make_s2f31();  // Host -> Equipment

    // Convert routine
    static int ascii2tm(const BCHAR * timestr, struct tm * outm);
    static BS2Item * clockItem();      // The return item for report (rptid + clock)
    static JGTimeModule * instance();

    // Watchdog timer for trigger
    JGTriggerSubject * triggerSubject(const char * trgid);

    JGTriggerSubTable * trgsubTable()  { return &m_trgsubs; }
    JGTriggerInfos *    trginfoTable() { return &m_trginfos; }

    void dump() const;
    void delta(ACE_Time_Value& tv) { m_correctTime = tv; }
    ACE_Time_Value delta()         { return m_correctTime; }

protected:
    void linkAction();
    int  time_svc(void);

    //
private:
    int  m_timeformat;
    bool m_changingTime;
    long m_timerid;            // Polling timer id

    // Correct time that is the local machine and host requested
    ACE_Time_Value m_correctTime;

    // Watch variables
    JGTriggerInfos  m_trginfos;
    JGTriggerSubTable m_trgsubs;
};


#endif
