// $Id: JGObjectManager.h,v 1.7 2003/02/09 16:15:13 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGObjectManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGOBJECTMANAGER_H
#define JGOBJECTMANAGER_H

#include "jyugem/gem/JGManager.h"
#include "jyugem/gem/JGClass.h"
#include "jyugem/gem/JGObject.h"

class JGErrorList;
class JGSpecification;
class BS2Message;
class BS2Item;


//
// Specification
//
class BEE_Export JGObjectManager : public JGManager
{
    friend class ACE_Singleton<JGObjectManager, ACE_Null_Mutex>;

public:
    JGObjectManager();
    ~JGObjectManager();

    virtual int init(void * argv = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg = NULL);

    // Find class and object by name
    JGClass * find(const string& name) const;
    JGClass * findByUser(const string& name) const;
    JGObject * findObject(const string& name) const;

    // Add new class
    int add(JGClass * cls);

    // Entry new object
    int addObject(JGObject * obj);

    // Remove object
    int remove(JGObject * obj);

    // Get objects
    int getAllClasses(JGClasses& clazzes);
    int getAllObjects(JGObjects& objs);
    JGSpecification * specification() { return m_env; }

protected:
    // Parse message
    BS2Message * reqGetAttr(BS2Message * msg);      // S14F1
    BS2Message * reqSetAttr(BS2Message * msg);      // S14F3
    BS2Message * reqGetType(BS2Message * msg);      // S14F5
    BS2Message * reqGetAttrName(BS2Message * msg);  // S14F7
    BS2Message * reqCreateObj(BS2Message * msg);    // S14F9
    BS2Message * reqDeleteObj(BS2Message * msg);    // S14F11

protected:
    JGSpecification * m_env;
};

typedef ACE_Singleton<JGObjectManager, ACE_Null_Mutex> ObjManager;

#endif  /* JGOBJECTMANAGER_H */
