// $Id: JGMemoryMappedFile.h,v 1.5 2003/07/27 13:27:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGMemoryMappedFile.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGMEMORYMAPPEDFILE_H
#define JGMEMORYMAPPEDFILE_H

#include "jyugem/gem/gembase.h"
#include "ace/Mem_Map.h"


//
// Management of mmap
//
class BEE_Export JGMemoryMappedFile
{
public:
    JGMemoryMappedFile(const string& dir, const string& fname,
                       const string& ext, int maxq = 0)
            : m_dir(dir), m_fname(fname), m_ext(ext), m_max(maxq) {}
    ~JGMemoryMappedFile() { m_mmap.sync(); m_mmap.close(); }

    JGMemoryMappedFile& operator=(const JGMemoryMappedFile& rhs);

    int    map(bool clear = false);
    int    read(BYTE * addr, BYTE * buf, size_t words);
    int    write(BYTE * buf, size_t words);
    size_t size() { return m_mmap.size(); }
    BYTE * top()  { return (BYTE *)m_mmap.addr(); }

    void dump() const;

//
protected:
    JGMemoryMappedFile() : m_dir(_TX("")), m_fname(_TX("")), m_ext(".map"),
                           m_max(0) {}
    void copy(const JGMemoryMappedFile& rhs);
    int  init(const string& dir, const string& fname, const string& ext,
              int maxq, bool clear = false);
    void flush() { m_mmap.sync(); }

// member variables
protected:
    string  m_dir;             // directory that make mmap file.
    string  m_fname;           // filename that make mmap file.
    string  m_ext;             // mmap file's extention
    string  m_path;            // mmap file's path
    size_t  m_max;             // max size
    BYTE *  m_current;
    ACE_Mem_Map m_mmap;

};


#endif  /* JGBLOCKINGMEMORY_H */
