// $Id: JGManager.h,v 1.4 2003/07/27 13:27:47 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGMANAGER_H
#define JGMANAGER_H

#include "jyugem/gem/gembase.h"
#include "jyugem/gem/JGDefineEvent.h"
#include "jyugem/gem/JGDefineVariable.h"
#include "jyugem/gem/JGDefineTrigger.h"
#include "jyugem/gem/JGTask.h"

#ifndef TRIGGER_INITIALIZE
#define TRIGGER_INITIALIZE _TX("INITIALIZE")
#define TRIGGER_TIMEOUT    _TX("TIMEOUT")
#define TRIGGER_FINISH     _TX("FINISH")
#endif

#ifndef CATEGORY_IGNORE
#define CATEGORY_IGNORE        _TX("IGNORE")
#define CATEGORY_ACCESS        _TX("ACCESS")
#define CATEGORY_ALARM         _TX("ALARM")
#define CATEGORY_COMM          _TX("COMMUNICATION")
#define CATEGORY_CONTROL       _TX("CONTROL")
#define CATEGORY_EVENT         _TX("EVENT")
#define CATEGORY_LIMIT         _TX("LIMIT")
#define CATEGORY_MATERIAL      _TX("MATERIAL")
#define CATEGORY_MATEIO        _TX("MATEIO")
#define CATEGORY_MATEMOVE      _TX("MATEMOVE")
#define CATEGORY_PROCESS       _TX("PROCESS")
#define CATEGORY_PROCPROG      _TX("PROCPROG")
#define CATEGORY_RECIPE        _TX("RECIPE")
#define CATEGORY_RCPEXE        _TX("RCPEXE")
#define CATEGORY_RESOURCE      _TX("RESOURCE")
#define CATEGORY_SPOOL         _TX("SPOOL")
#define CATEGORY_TERMINAL      _TX("TERMINAL")
#define CATEGORY_TRACE         _TX("TRACE")
#define CATEGORY_RCMD          _TX("RCMD")
#define CATEGORY_INFO          _TX("INFO")
#define CATEGORY_CLOCK         _TX("CLOCK")
#define CATEGORY_IODEVICE      _TX("IODEVICE")
#define CATEGORY_OBJECT        _TX("OBJECT")
#define CATEGORY_CONTROLJOB    _TX("CONTROLJOB")
#define CATEGORY_PROCESSJOB    _TX("PROCESSJOB")
#endif

// Forward declaration
class JGVariable;
class JGEquipment;
class JGObserver;
class JGCommDevice;
class JGMessageTrigger;
class JGDeviceTrigger;
class JGNotifyTrigger;
class JGOperatorTrigger;
class JGService;
class JGStateTask;
class BS2Message;
class BS2MessageInfo;
class BS2Item;

//
struct SECSTransaction
{
    SECSTransaction(int devid, int sf, int transid)
        : m_devid(devid), m_sf(sf), m_transid(transid) {}
    SECSTransaction(const SECSTransaction& rhs)
        : m_devid(rhs.m_devid), m_sf(rhs.m_sf), m_transid(rhs.m_transid) {}
    ~SECSTransaction() {}

    SECSTransaction& operator=(const SECSTransaction& rhs)
    {
        if (this != &rhs)
        {
            m_devid = rhs.m_devid;
            m_sf = rhs.m_sf;
            m_transid = rhs.m_transid;
        }
        return *this;
    }

    bool operator==(const SECSTransaction& rhs)
    {
        if ((m_devid == rhs.m_devid) && (m_sf == rhs.m_sf) &&
            (m_transid == rhs.m_transid))
        {
            return true;
        }
        if ((m_devid == 0) && (m_sf == 0) && (m_transid == rhs.m_transid))
        {
            return true;
        }
        if ((rhs.m_devid == 0) && (rhs.m_sf == 0) && (m_transid == rhs.m_transid))
        {
            return true;
        }
        return false;
    }

    bool operator<(const SECSTransaction& rhs) const
    {
        if ((m_devid == rhs.m_devid) && (m_sf == rhs.m_sf) &&
            (m_transid < rhs.m_transid))
        {
            return true;
        }
        if ((m_devid == 0) && (m_sf == 0) && (m_transid < rhs.m_transid))
        {
            return true;
        }
        if ((rhs.m_devid == 0) && (rhs.m_sf == 0) && (m_transid < rhs.m_transid))
        {
            return true;
        }
        return false;
    }

    int  m_devid;
    int  m_sf;
    UINT m_transid;   // transaction id of SECS
};


struct transid_less
{
    bool operator()(const SECSTransaction& lhs, const SECSTransaction& rhs) const
    {
        return (lhs < rhs);
    }
};

typedef map<SECSTransaction, int, transid_less>    Transaction;

class JGManager;
struct JGFunctor
{
    JGFunctor(JGManager * mngr) : m_manager(mngr) {}
    virtual ~JGFunctor() {}

    virtual void call(int tid) = 0;

    JGManager * m_manager;
};

//-----------------------------------------------------------------------------
//
// GEM Management class
//
//-----------------------------------------------------------------------------
class BEE_Export JGManager: public JGTask
{
    friend class JGMessageRequest;
    friend class JGDeviceRequest;
    friend class JGOperatorRequest;
    friend class JGNotifyRequest;
    friend class JGRemoteRequest;

public:
    typedef map<SECSTransaction, int, transid_less>    Transaction;

    JGManager(const string& name);
    virtual ~JGManager();

    virtual int init(void * argv = 0);
    virtual int open(void * argv = 0);     // start service thread
    virtual int close(int arg = 0);
    virtual int svc(void);

    // for state model
    virtual int notify(JGTrigger * trigger);
    virtual int notify(const string& category);
    virtual int notify(const string& category, JGVariable * var,
                       void * arg);
    virtual int notify(JGService * rcmd);
    virtual int notify(BS2MessageInfo& msginfo);

    // Send SECS Message
    virtual int send(BS2Message * msg);
    virtual int send(BS2Message * msg, int tid);

    void equipment(JGEquipment * equip) { m_equipment = equip; }
    void device(JGCommDevice * dev)     { m_device = dev; }
    JGEquipment * equipment() { return m_equipment; }
    JGCommDevice * device()   { return m_device; }
    void stateTask(JGStateTask * st)    { m_hsmTask = st; }
    BS2Item * getDataID();
    int sendEvent(const string& evtid, JGVariable * var = NULL);
    int sendObjectEvent(const string& evtid);
    int start() { return this->notify(TRIGGER_INITIALIZE); }
    int stop()  { return this->notify(TRIGGER_FINISH); }
    int eraseTransaction(int secstid);

    static JGManager * instance(const string& category);
    static void dump_all();

//
protected:
    BS2Message * unrecognized(BS2Message *);  // Make unrecognized message
    int comm_error(JGMessageTrigger * trigger);

    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int device_svc(JGDeviceTrigger * trigger);  // trigger from I/O devices
    virtual int notify_svc(JGNotifyTrigger * trigger);
    virtual int ope_svc(JGOperatorTrigger * trigger);
    virtual int rcmd_svc(JGService * trigger);

protected:
    JGEquipment *  m_equipment;
    JGCommDevice * m_device;
    JGStateTask *  m_hsmTask;
    JGFunctor *    m_timeout;

    Transaction m_trans;
};


#endif
