// $Id$

//=============================================================================
/**
 *  @file    JGLimitFactory.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGLIMITFACTORY_H
#define JGLIMITFACTORY_H

#include "jyugem/gem/gembase.h"

#ifndef MAX_LIMIT_ZONE
#define MAX_LIMIT_ZONE   7
#endif

class JGLimit;
class JGVariable;

//
// Define an object to hold configure data
//
class BEE_Export JGLimitFactory
{
public:
    struct DeadBand
    {
        string m_lower;
        string m_upper;
        bool   m_enabled;

        DeadBand() : m_lower(_TX("")), m_upper(_TX("")), m_enabled(false) {}
    };

    typedef map<string, JGLimitFactory *, std::less<string> >  dictionary;

    // Constructor/Destructor
    JGLimitFactory() : m_typeName(_TX("")), m_units(_TX("")), m_maxval(_TX("")),
                       m_minval(_TX("")), m_enabled(false) {}
    JGLimitFactory(const JGLimitFactory& rhs) { this->copy(rhs); }
    ~JGLimitFactory() {}

    JGLimitFactory& operator=(const JGLimitFactory& rhs)
    {
        if (this == &rhs)
            return *this;
        this->copy(rhs);
        return *this;
    }

    const string& typeName() const { return m_typeName; }
    const string& units() const    { return m_units; }
    bool enabled() const { return m_enabled; }

    JGLimit * create(JGVariable * var);

protected:
    void copy(const JGLimitFactory& rhs)
    {
        m_typeName = rhs.m_typeName;
        m_units = rhs.m_units;
        m_maxval = rhs.m_maxval;
        m_minval = rhs.m_minval;
        m_enabled = rhs.m_enabled;
        for (int i = 0; i < MAX_LIMIT_ZONE; i++)
        {
            m_dbs[i].m_lower = rhs.m_dbs[i].m_lower;
            m_dbs[i].m_upper = rhs.m_dbs[i].m_upper;
            m_dbs[i].m_enabled = rhs.m_dbs[i].m_enabled;
        }
    }

protected:
    string m_typeName;
    string m_units;
    string m_maxval;               // max value
    string m_minval;               // min value
    bool   m_enabled;
    DeadBand m_dbs[MAX_LIMIT_ZONE];
};

#endif  /* JGLIMITFACTORY_H */
