// $Id: JGLimit.h,v 1.6 2003/03/16 14:51:00 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGLimit.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGLIMIT_H
#define JGLIMIT_H

#include "jyugem/gem/gembase.h"
#include "jyugem/gem/JGNameInfo.h"
#include "jyugem/gem/JGVariable.h"

#ifndef MAX_LIMIT_ZONE
#define MAX_LIMIT_ZONE 7
#endif

const int MIN_LIMITID = 1;
const int MAX_LIMITID = MAX_LIMIT_ZONE;

class BS2ListItem;
class BS2Message;

enum
{
    LIMIT_TRANSITION_NONE = -1,
    LIMIT_TRANSITION_LOWER = 0,
    LIMIT_TRANSITION_UPPER = 1
};


//
// Limit DeadBand infomation
//
class JGLimitBorder
{
    friend class JGLimit;
    friend class JGLimitManager;
    friend class JGLimitFactory;
    friend struct comp_border;

public:
    JGLimitBorder() : m_vid(0), m_limid(0), m_enabled(false), m_upval(0),
            m_lowval(0), m_lastTransition(LIMIT_TRANSITION_NONE) {}
    JGLimitBorder(JGid& id, int limid) : m_vid(id), m_limid(limid),
            m_enabled(false), m_upval(0), m_lowval(0),
            m_lastTransition(LIMIT_TRANSITION_NONE) {}
    JGLimitBorder(const JGLimitBorder& rhs) { this->copy(rhs); }

    JGLimitBorder& operator=(const JGLimitBorder& rhs)
    {
        if (this != &rhs)
            this->copy(rhs);
        return *this;
    }

    void  vid(JGid& id)  { m_vid = id; }
    JGid& vid()          { return m_vid; }
    void  limitId(int i) { m_limid = i; }
    int   limitId()      { return m_limid; }
    JGvalue& upperdb()   { return m_upval; }
    JGvalue& lowerdb()   { return m_lowval; }
    bool enabled() const { return m_enabled; }
    void upperdb(JGvalue& upv)  { m_upval = upv; }
    void lowerdb(JGvalue& lowv) { m_lowval = lowv; }
    void enabled(bool enabled)  { m_enabled = enabled; }

    int transition(JGvalue& last, JGvalue& current);
    BS2Item * attributeItem();             // for S2F48

protected:
    void copy(const JGLimitBorder& rhs)
    {
        m_vid = rhs.m_vid;
        m_limid = rhs.m_limid;
        m_enabled = rhs.m_enabled;
        m_upval = rhs.m_upval;
        m_lowval = rhs.m_lowval;
        m_lastTransition = rhs.m_lastTransition;
    }

protected:
    JGid m_vid;
    int  m_limid;
    //
    bool m_enabled;
    JGvalue m_upval;
    JGvalue m_lowval;
    int     m_lastTransition;
};

typedef vector<class JGLimitBorder>  JGLimitBorderSet;

//
// Define an object to hold configure data
//
class JGLimit : public JGNameVarInfo
{
    friend class JGLimitManager;
    friend class JGLimitFactory;

public:
    JGLimit(JGid& vid) : JGNameVarInfo(),
            m_manager(NULL), m_variable(NULL), m_factory(NULL),
            m_limitid(0), m_transition(LIMIT_TRANSITION_NONE), m_maxval(0),
            m_minval(0), m_enabled(false), m_defined(false), m_trnum(0),
            m_tv(0)
    {
        m_vid = vid;
        for (int i = 0; i < MAX_LIMIT_ZONE; i++)
            m_ids[i] = 0;
    }
    JGLimit(JGVariable * var) : JGNameVarInfo(),
            m_manager(NULL), m_variable(var), m_factory(NULL), m_limitid(0),
            m_transition(LIMIT_TRANSITION_NONE), m_maxval(0), m_minval(0),
            m_enabled(false), m_defined(false), m_trnum(0), m_tv(0)
    {
        m_id = var->limitCeid();
        m_vid = var->vid();
        var->limit(this);              // Set limit information
        for (int i = 0; i < MAX_LIMIT_ZONE; i++)
            m_ids[i] = 0;
    }
    JGLimit(const JGLimit& rhs) { this->copy(rhs); }
    ~JGLimit() {}

    JGLimit& operator=(const JGLimit& rhs)
    {
        if (this != &rhs)
            this->copy(rhs);
        return *this;
    }
    void insert(JGLimitBorder& border) { m_borders.push_back(border); }

    JGid& ceid()                { return m_id; }
    void  ceid(JGid& id)        { m_id = id;  m_id.get(m_name); }
    bool  enabled() const       { return m_enabled; }
    void  enabled(bool enabled) { m_enabled = enabled; }
    bool  defined() const       { return m_defined; }
    void  defined(bool enabled) { m_defined = enabled; }
    void  manager(JGLimitManager * mngr)    { m_manager = mngr; }
    void  factory(JGLimitFactory * factory) { m_factory = factory; }
    void  sort();
    JGLimitBorderSet& limitBorders() { return m_borders; }
    JGLimitBorder * find(int limid);

    int transition(JGvalue& last, JGvalue& current);
    BS2ListItem * checkNewBorders(JGLimit& req);  // Check defined limit attributes in S2F45
    int updateNewBorders(JGLimit& req);           // Update limit attributes in S2F45
    BS2Item * attributeItem();          // for S2F48
    BS2Item * ceidItem(int format);     // for S6F11
    BS2Atom * getAtom(const string& varName);

protected:
    JGLimit() : JGNameVarInfo(),
            m_manager(NULL), m_variable(NULL), m_factory(NULL),
            m_limitid(0), m_transition(LIMIT_TRANSITION_NONE), m_maxval(0),
            m_minval(0), m_enabled(false), m_defined(false), m_trnum(0),
            m_tv(0)
    {
        for (int i = 0; i < MAX_LIMIT_ZONE; i++)
            m_ids[i] = 0;
    }

    void copy(const JGLimit& rhs)
    {
        this->JGNameVarInfo::copy(rhs);
        m_manager = rhs.m_manager;
        m_variable = rhs.m_variable;
        m_factory = rhs.m_factory;
        m_limitid = rhs.m_limitid;
        m_transition = rhs.m_transition;
        m_maxval = rhs.m_maxval;
        m_minval = rhs.m_minval;
        m_enabled = rhs.m_enabled;
        m_defined = rhs.m_defined;
        m_trnum = rhs.m_trnum;
        m_tv = rhs.m_tv;

        m_borders = rhs.m_borders;
        for (int i = 0; i < MAX_LIMIT_ZONE; i++)
            m_ids[i] = rhs.m_ids[i];
    }

protected:
    JGLimitManager * m_manager;
    JGVariable *     m_variable;
    JGLimitFactory * m_factory;
    JGLimitBorderSet m_borders;     // limit border list
    int  m_limitid;                 // recent limitted id
    int  m_transition;
    JGvalue m_maxval;               // max value
    JGvalue m_minval;               // min value
    bool m_enabled;
    bool m_defined;
    int  m_trnum;                   // transit zone count
    BYTE m_ids[MAX_LIMIT_ZONE];     // transit limit ids
    ACE_Time_Value m_tv;            // recent transit zone time
};

// Compare Limit Borders
struct comp_border
{
    bool operator() (const JGLimitBorder& x, const JGLimitBorder& y) const
    {
        return (x.m_upval < y.m_upval);
    }
};

//
typedef map<JGid, JGLimit *, id_less > JGLimitTable;
typedef JGLimitTable::value_type  JGLimitPair;
typedef vector<JGLimit>   JGLimitArray;
typedef vector<JGLimit *> JGLimits;
typedef list<JGLimit *>   JGLimitList;

#endif  /* JGLIMIT_H */
