// $Id: JGDefineEvent.h,v 1.2 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGDefineEvent.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGDEFINEEVENT_H
#define JGDEFINEEVENT_H

//
// event id in libgem
//
#define EVT_OFFLINE                 _TX("EquipmentOffLine")
#define EVT_LOCAL                   _TX("ControlStateLocal")
#define EVT_REMOTE                  _TX("ControlStateRemote")
#define EVT_OPERATOR_COMMAND        _TX("OperatorCommandIssued")
#define EVT_PROC_START              _TX("ProcessingStarted")
#define EVT_PROC_COMPLETED          _TX("ProcessingCompleted")
#define EVT_PROC_STOPPED            _TX("ProcessingStopped")
#define EVT_PROC_STATE              _TX("ProcessingStateChanged")
#define EVT_ALARM_DETECTED          _TX("AlarmDetected")
#define EVT_ALARM_CLEARED           _TX("AlarmCleared")
#define EVT_EC_CHANGED              _TX("EquipmentConstantChange")
#define EVT_LIMIT                   _TX("LimitZoneTransition")
#define EVT_PP_CHANGE               _TX("ProcessProgramChange")
#define EVT_PP_SELECTED             _TX("ProcessProgramSelected")
#define EVT_MATERIAL_RECV           _TX("MaterialReceived")
#define EVT_MATERIAL_MOVE           _TX("MaterialMoved")
#define EVT_MATERIAL_REMOVED        _TX("MaterialRemoved")
#define EVT_SPOOL_ACTIVATED         _TX("SpoolingActivated")
#define EVT_SPOOL_DEACTIVATED       _TX("SpoolingDeactivated")
#define EVT_SPOOL_FAILURE           _TX("SpoolingTransmitFailure")
#define EVT_MSG_RECOGNITION         _TX("MessageRecognition")
#define EVT_RECIPE_NEW              _TX("NewExecuteRecipe")
#define EVT_RECIPE_STATUS           _TX("ChangeExecRecipeStatus")

#define EVT_LP_TRANSFER_BLOCKED     _TX("LoadportTransferBlocked")
#define EVT_LP_READY_TO_UNLOAD      _TX("LoadportReadyToUnload")
#define EVT_LP_READY_TO_LOAD        _TX("LoadportReadyToLoad")
#define EVT_LP_OUT_OF_SERVICE       _TX("LoadportOutOfService")
#define EVT_LP_AUTO_ACCESS          _TX("LoadportAutoAccess")
#define EVT_LP_MANUAL_ACCESS        _TX("LoadportManualAccess")
#define EVT_LP_RESERVED             _TX("LoadportReserved")
#define EVT_LP_NOT_RESERVED         _TX("LoadportNotReserved")
#define EVT_LP_ASSOCIATED           _TX("LoadportAssociated")
#define EVT_LP_NOT_ASSOCIATED       _TX("LoadportNotAssociated")
#define EVT_CARRIER_CREATED         _TX("CarrierCreated")
#define EVT_CARRIER_DELETED         _TX("CarrierDeleted")
#define EVT_CARRIER_APPROACH        _TX("CarrierApproachingComplete")
#define EVT_CARRIER_ID_NOT_READ     _TX("CarrierIDNotRead")
#define EVT_CARRIER_ID_WAIT_HOST    _TX("CarrierIDWaitingForHost")
#define EVT_CARRIER_ID_OK           _TX("CarrierIDVerificationOK")
#define EVT_CARRIER_ID_FAIL         _TX("CarrierIDVerificationFail")
#define EVT_CARRIER_MAP_WAIT_HOST   _TX("CarrierMapWaitingForHost")
#define EVT_CARRIER_MAP_OK          _TX("CarrierMapVerificationOK")
#define EVT_CARRIER_MAP_FAIL        _TX("CarrierMapVerificationFail")
#define EVT_CARRIER_IN_ACCESS       _TX("CarrierInAccess")
#define EVT_CARRIER_COMPLETE        _TX("CarrierComplete")
#define EVT_CARRIER_STOPPED         _TX("CarrierStopped")
#define EVT_CARRIER_NOT_ACCESSED    _TX("CarrierNotAccessed")

#define EVT_CARRIER_OPENED          _TX("CarrierOpened")
#define EVT_CARRIER_CLOSED          _TX("CarrierClosed")
#define EVT_CARRIER_ID_READ_FAIL    _TX("CarrierIDReadFail")

//
// S6F11 CEID
//
#define CEID_OFFLINE                _TX("OFFLINE")
#define CEID_LOCAL                  _TX("LOCAL")
#define CEID_REMOTE                 _TX("REMOTE")
#define CEID_COMMAND                _TX("COMMAND")
#define CEID_PROCESS_START          _TX("PROCESS-START")
#define CEID_PROCESS_COMPLETE       _TX("PROCESS-COMPLETE")
#define CEID_PROCESS_STOP           _TX("PROCESS-STOP")
#define CEID_PROCESS_CHANGE         _TX("PROCESS-CHANGE")
#define CEID_ALARM_DETECT           _TX("ALARM-DETECT")
#define CEID_ALARM_CLEAR            _TX("ALARM-CLEAR")
#define CEID_ECV_CHANGED            _TX("ECV-CHANGED")
#define CEID_LIMIT                  _TX("LIMIT:%s")
#define CEID_PP_CHANGE              _TX("PP-CHANGE")
#define CEID_PP_SELECT              _TX("PP-SELECT")
#define CEID_MATERIAL_RECEIVE       _TX("MATERIAL-RECEIVE")
#define CEID_MATERIAL_MOVE          _TX("MATERIAL-MOVE")
#define CEID_MATERIAL_REMOVED       _TX("MATERIAL-REMOVED")
#define CEID_SPOOL_ACTIVATED        _TX("SPOOL-ACTIVATED")
#define CEID_SPOOL_DEACTIVATED      _TX("SPOOL-DEACTIVATED")
#define CEID_SPOOL_FAILURE          _TX("SPOOL-FAILURE")
#define CEID_MSG_RECOGNITION        _TX("MSG-RECOGNITION")
#define CEID_RECIPE_SELECT          _TX("RECIPE-SELECT")
#define CEID_RECIPE_CHANGE          _TX("RECIPE-CHANGE")

#endif
