// $Id: JGCommDevice.h,v 1.1 2003/02/02 15:59:26 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGCommDevice.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGCOMMDEVICE_H
#define JGCOMMDEVICE_H

#include "beesecs.h"
#include "BS2Device.h"
#include "BS2Message.h"

class JGEquipment;
class JGManager;
class BS2TransactionManager;
class BS2MessageInfo;

#define MSGEVT_ERROR            _TX("MESSAGE:Error")
#define MSGEVT_ABORT            _TX("MESSAGE:Abort")
#define MSGEVT_TIMEOUT          _TX("MESSAGE:Timeout")

//-----------------------------------------------------------------------------
//
// Host Communication Device Module
//
//-----------------------------------------------------------------------------
class BEE_Export JGCommDevice: public BS2Device
{
public:
    JGCommDevice();
    ~JGCommDevice();

    virtual int svc(void);
    virtual int connected();
    virtual int disconnected();

    void setEquipment(JGEquipment * equip) { m_equipment = equip; }

    int  send(BS2Message * msg, JGManager * mngr);

protected:
    int gotoManager(BS2MessageInfo& msginfo, const BCHAR * evtname = NULL);

protected:
    JGEquipment * m_equipment;

};

#endif
