// $Id: JGClass.h,v 1.4 2003/02/28 14:44:50 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGClass.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGCLASS_H
#define JGCLASS_H

#include "jyugem/gem/gembase.h"
#include "jyugem/gem/JGObject.h"
#include "jyugem/gem/JGSpecification.h"

class BS2Item;

//
// Class
//
class JGClass : public b_objtype
{
    friend class JGObject;

public:
    JGClass(const string& name, JGSpecification * spec = NULL)
            : b_objtype(name, spec) { this->init(); }
    virtual ~JGClass() {}

    // Initial attributes
    virtual int init() { return 0; }

    // Create object
    JGObject * instance(const string& name) {
            return reinterpret_cast<JGObject *>(this->b_objtype::instance(name.c_str()));
        }
    JGObject * instance() {
            return reinterpret_cast<JGObject *>(this->b_objtype::instance());
        }

    // Get all objects
    int getAllObjects(vector<JGObject *>& objects) {
            b_objects objs;
            int result = this->allObject(objs);
            for (size_t i = 0; i < objs.size(); i++)
            {
                objects.push_back(reinterpret_cast<JGObject *>(objs[i]));
            }
            return result;
        }

    // Create messages
    BS2Item * getObjType();             // for S14F6
    BS2Item * getAttrName();            // for S14F8

    void dump() const;

protected:
    int initBase();

};

typedef vector<JGClass *>   JGClasses;

#endif  /* JGCLASS_H */
