// $Id: JGAlarm.h,v 1.3 2003/02/02 15:59:25 fukasawa Exp $

//=============================================================================
/**
 *  @file    JGAlarm.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JGALARM_H
#define JGALARM_H

#include "jyugem/gem/JGNameInfo.h"

class JGVariable;
class JGAlarmManager;
class JGAlarm;
class BS2Item;

// Define an object to hold configure data
class JGAlarm : public JGNameVarInfo
{
public:
    JGAlarm() : JGNameVarInfo(), m_altx(_TX("")), m_almstatus(false),
                m_enabled(false), m_alcd(0), m_disposal(_TX("")) {}
    virtual ~JGAlarm() {}
    virtual void printOn(string& buf, int mode = 0);

    string& altx() { return m_altx; }
    JGid&  alid()  { return m_id; }
    void alid(JGid& alid)     { m_id = alid;  m_id.get(m_name); }
    void enabled(bool enable) { m_enabled = enable; }
    void status(bool status)
    {
        m_laststatus = m_almstatus;  m_almstatus = status;
    }
    void alcd(int code)     { m_alcd = code; }
    int  alcd() const       { return m_alcd; }
    bool enabled() const    { return m_enabled; }
    bool status() const     { return m_almstatus; }
    bool laststatus() const { return m_laststatus; }
    void manager(JGAlarmManager * mngr) { m_manager = mngr; }
    JGid& vid() { return m_vid; }

    // create item data for SECS-II.
    BS2Item * alarm();   // alcd + alid + altx
    BS2Item * aled();    // aled + alid

protected:
    string m_altx;
    bool   m_almstatus;
    bool   m_laststatus;
    bool   m_enabled;
    int    m_alcd;
    string m_disposal;
    JGid   m_vid;           // relate vid

    JGAlarmManager * m_manager;
};

//
// Alarm Code
//
class JGAlcd
{
public:
    JGAlcd() : m_alcd(0), m_alcd_text(""), m_danger(0),
               m_operator(false), m_equipment(false),
               m_material(false) { }

    JGAlcd(int alcd, string& alcd_text, int danger, bool ope,
           bool equipment, bool material)
        : m_alcd(alcd), m_alcd_text(alcd_text), m_danger(danger),
          m_operator(ope), m_equipment(equipment),
          m_material(material) { }

protected:
    int    m_alcd;
    string m_alcd_text;
    int    m_danger;
    bool   m_operator;
    bool   m_equipment;
    bool   m_material;

};

typedef map<JGid, JGAlarm, id_less, allocator<JGAlarm> >     JGAlarmTable;
typedef map<JGid, JGAlarm *, id_less, allocator<JGAlarm *> > JGAlarmMap;
typedef JGAlarmTable::value_type  JGAlarmPair;
typedef JGAlarmMap::value_type    JGAlarmPtrPair;
typedef vector<JGAlarm *> JGAlarms;
typedef list<JGAlarm *>   JGAlarmList;

#endif  /* JGALARM_H */
