// $Id$

//=============================================================================
/**
 *  @file    dbio.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2003-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef DBIO_H
#define DBIO_H

#include <string>
using namespace std;
#include "jyugem/gem/gembase.h"

class JGEquipment;

//
// Equipment's information DataBase
//
class BEE_Export dbio : public MT_Task
{
public:
    dbio(const char * fname = NULL)
    {
        m_fname = (fname != NULL) ? fname : "";
    }
    virtual ~dbio() {}

    virtual int  open(const string& dbfname) = 0;
    virtual int  drop(const string& tableName) = 0;
    virtual void close() = 0;

    virtual int  load(JGEquipment * equip) = 0;
    virtual int  save(JGEquipment * equip) = 0;
    virtual int  putcmds(const vector<string>& cmds) = 0;
    virtual int  sqlcmd(const string& sql) = 0;  // support transaction

    static dbio * instance(dbio * db = NULL);

//
protected:
    virtual int  begin_trans() = 0;         // Begin Transaction
    virtual int  commit() = 0;              // End Transaction
    virtual int  rollback() = 0;            // Abort Transaction

// member variables
protected:
    string m_fname;
    ACE_Thread_Mutex m_lock;    // mutex for i/o
};


#endif  /* DBIO_H */
