// $Id$

//=============================================================================
/**
 *  @file    expression.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================
#ifndef JYUGEM_SEQUENCER_EXPRESSION_H
#define JYUGEM_SEQUENCER_EXPRESSION_H

namespace jyugem { namespace sequencer
{

temptate<class EXP, class T>
struct BEE_Export expression : public sequencer<T>::step
{
    typedef sequencer<T>       seq_type;
    typedef sequencer<T>::step step_base;

    expression(seq_type * sqcr) : step_base(sqcr) {}
    expression(seq_type * sqcr, const string& cond) : step(sqcr)
    {
        m_test.parse(cond);
    }
    virtual ~expression() {}

    virtual int parse(const string& cond)
    {
        m_test.parse(cond);
    }

    EXP m_test;
    std::vector<step *> m_act;
};


} } // *namespace*

#endif
