// $Id$

//=============================================================================
/**
 *  @file    HSTraceManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2003 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSTRACEMANAGER_H
#define HSTRACEMANAGER_H

#include "jyugem/gem/JGTraceManager.h"

/*
 *
 */
class HSTraceManager: public JGTraceManager
{
public:
    HSTraceManager();
    ~HSTraceManager();

    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    int setup(int tid, bool enable, int trace_id, size_t frequency,
              size_t samples, size_t report_size,
              const std::vector<std::string>& vids, const std::string& dir);

    static HSTraceManager * instance();

//
protected:
    int          traceStart(BS2Message * msg);  // S2F24
    BS2Message * traceRecord(BS2Message * msg); // S6F1
// member variables
protected:
    JGTrace * m_recentTrace;
};


#endif
