// $Id$

//=============================================================================
/**
 *  @file    HSRemoteCmd.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSREMOTECMD_H
#define HSREMOTECMD_H

#include "jyugem/gem/gembase.h"

/*
 * Trcipe's parameter : S16F3, S16F5, ...
 */
struct RcpParam
{
    string  m_pname;
    JGvalue m_pval;

    RcpParam(): m_pname(_TX("")), m_pval(0) {}
    RcpParam(const RcpParam& rhs) {
        m_pname = rhs.m_pname; m_pval = rhs.m_pval;
    }
    RcpParam& operator=(const RcpParam& rhs) {
        if (this == &rhs)
            return *this;
        m_pname = rhs.m_pname; m_pval = rhs.m_pval;
        return *this;
    }
};

/*
 * Action's parameter : S3F17, S3F21, ...
 */
typedef RcpParam ActionParam;


/*
 * Command's parameter :  (for S2F41 or S2F49)
 */
struct CmdParam
{
    JGid    m_cpname;
    JGvalue m_cpval;
    BYTE    m_cpack;

    // code of CPACK,CEPACK
    enum
    {
        ILLEGAL_CPNAME = 1, ILLEGAL_VALUE = 2,
        ILLEGAL_FORMAT = 3, NAME_INVALID_USED = 4
    };

    CmdParam(): m_cpname(_TX("")), m_cpval(0), m_cpack(0) {}
    CmdParam(const CmdParam& rhs) {
        m_cpname = rhs.m_cpname; m_cpval = rhs.m_cpval; m_cpack = rhs.m_cpack;
    }
    CmdParam& operator=(const CmdParam& rhs) {
        if (this == &rhs)
            return *this;
        m_cpname = rhs.m_cpname; m_cpval = rhs.m_cpval; m_cpack = rhs.m_cpack;
        return *this;
    }
};

//
// Remote command & parameter (for S2F41 or S2F49)
//
struct HSRemoteCmd
{
    string m_rcmd;
    string m_objspec;
    int    m_hcack;
    vector<CmdParam> m_parms;

    // code of HCACK
    enum
    {
        ILLEGAL_RCMD = 1,  CANNOT_PERFORM = 2,    INVALID_PARAMETER = 3,
        PERFORM_LATER = 4, DESIRED_CONDITION = 5, NOT_EXIST_OBJECT = 6
    };

    HSRemoteCmd() : m_rcmd(_TX("")), m_objspec(_TX("")), m_hcack(0) {}
    HSRemoteCmd(const HSRemoteCmd& rhs)
    {
        m_rcmd = rhs.m_rcmd;  m_objspec = rhs.m_objspec;
        m_hcack = rhs.m_hcack;
        m_parms = rhs.m_parms;
    }
    HSRemoteCmd& operator=(const HSRemoteCmd& rhs)
    {
        if (this == &rhs)
            return *this;
        m_rcmd = rhs.m_rcmd;  m_objspec = rhs.m_objspec;
        m_hcack = rhs.m_hcack;
        m_parms = rhs.m_parms;
        return *this;
    }
};


#endif  /* HSREMOTECMD_H */
