// $Id$

//=============================================================================
/**
 *  @file    HSProcProgManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSPROCPROGMANAGER_H
#define HSPROCPROGMANAGER_H

#include "jyugem/gem/JGProcProgManager.h"

class BS2Message;
class BS2Item;
class BS2Binary;

/*
 * Process Program Manager Class
 */
class BEE_Export HSProcProgManager: public JGManager
{
public:
    typedef void (*userfp)(BYTE ** bufptr, size_t * sizeptr);

public:
    HSProcProgManager();
    ~HSProcProgManager();

    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);
    virtual int init(void * argv = 0);

    int pp_query(int tid, const std::string& file);
    int pp_upload(int tid, const std::string& ppid, const std::string& file);
    int pp_download(int tid, const std::string& ppid, size_t size, BYTE * body);

    static HSProcProgManager * instance();

//
protected:
    int pp_body(BS2Message * msg);
    int pp_grant(BS2Message * msg);
    int pp_inquire(BS2Message * msg);

protected:
    userfp m_userfp;
    ACE_Auto_Event m_event;

    std::string m_eppd;
    std::string m_ppid;
    BS2Binary * m_ppbody;
    std::string m_ppfile;
    std::string m_inqPpid;
    size_t m_inqLength;
    int    m_tid;
};


#endif  /* HSPROCPROGMANAGER */
