// $Id$

//=============================================================================
/**
 *  @file    HSInfoManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSINFOMANAGER_H
#define HSINFOMANAGER_H

#include "jyugem/gem/JGInfoManager.h"
#include "jyugem/gem/rcmd.h"
using namespace jyugem::cell;

/*
 * Reosource class
 */
class BEE_Export HSInfoManager: public JGInfoManager
{
public:
    HSInfoManager();
    ~HSInfoManager();

    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    int setParam(int tid, const std::vector<any_item>& params);  // set ECV
    int inqStatus(int tid, const std::vector<std::string>& vids,
                  const std::string& file);

    static HSInfoManager * instance();

//
protected:
    BS2Message * make_s1f3(vector<JGid>& svids);
    BS2Message * make_s2f15(vector<JGVariable *>& ecvs);

//
protected:
    string m_fileName;
};

#endif
