// $Id$

//=============================================================================
/**
 *  @file    HSCmdManager.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef HSCMDMANAGER_H
#define HSCMDMANAGER_H

#include "jyugem/gem/JGRCmdManager.h"
#include "jyugem/gem/rcmd.h"
using namespace jyugem::cell;

class BS2Message;
class BS2ListItem;
struct JGRemoteCmd;
typedef jyugem::cell::rcmd  host_cmd;

//
// Host Command Manager Class
//
class HSCmdManager: public JGRCmdManager
{
public:
    HSCmdManager();
    ~HSCmdManager();

    virtual int init(void * argv = 0);
    virtual BS2Message * msg_svc(JGMessageTrigger * trigger, BS2Message * msg);

    int request(const host_cmd& hcmd);
    int abort(int tid, const std::string& port, int level);
    int pause(int tid, const std::string& port);
    int resume(int tid, const std::string& port,
               const std::vector<any_item>& params);
    int set_param(int tid, const std::string& res_type,
                  const std::vector<any_item>& params);
    int start(int tid, const std::string& port, const std::string& lotid,
              int mbc_size, const std::vector<any_item>& params);
    int pp_select(int tid, const std::string& port,
                  const std::string& lotid, const std::string& ppid,
                  const std::vector<any_item>& params);

    static HSCmdManager * instance();

protected:
    BS2Message * makeCommand(JGRemoteCmd * cmdinfo, const host_cmd& hcmd);
    int parseResponse42(BS2Message * msg, JGTrigger * notify);
    int parseResponse50(BS2Message * msg, JGTrigger * notify);
    int makeBaseItems(const std::string& cmd, const std::string& port,
                      BS2Message ** msgptr, BS2ListItem ** paramsptr);

private:
    int m_sf;
};

#endif
