#! /usr/local/bin/python
# -*- coding: UTF-8 -*-

# $Id$
#=============================================================================
#
#  @file    hostsim.py
#
#  @author Fukasawa Mitsuo
#
#    Copyright (C) 2004 BEE Co.,Ltd. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#=============================================================================

import getopt, sys, string, os
import cmd
import hostsim

mid = "dev123456"

vfei_tests = { "ABORT": 'CMD/A="ABORT" MID/A="STP1" MTY/A="C" TID/U4=1',
    "ABORT_1": 'CMD/A="ABORT" MID/A="TRK1" MTY/A="C" TID/U4=2 LEVEL/U2=3 MG/A="WAFER1"',
    "ALARM_REPORT": 'CMD/A="ALARM_REPORT" MID/A="STP1" MTY/A="E" ECD/U4=0 ETX/A="" ALARM_ID/I4=353 ALARM_STATE/U1=1 ALARM_TEXT/A="WAFER ARM JAMMED"',
    "ALARM_SETUP":  'CMD/A="ALARM_SETUP" MID/A="STP1" MTY/A="C" TID/U4=1 ENABLE/U1=0',
    "ALARM_SETUP_1": 'CMD/A="ALARM_SETUP" MID/A="STP1" MTY/A="C" TID/U4=2 ENABLE/U1=0 ALARM_ID/I4[3]=[1 2 3]',
    "CMD_ACK":   'CMD/A="CMD_ACK" MID/A="STP1" MTY/A="R" TID/U4=1 ECD/U4=0 ETX/A=""',
    "CMD_ACK_1": 'CMD/A="CMD_ACK" MID/A="STP1" MTY/A="R" TID/U4=1 ECD/U4=50000 ETX/A="EQUIP_UNKNOWN_ERROR"',
    "DISPLAY_MSG":   'CMD/A="DISPLAY_MSG" MID/A="TRK1" MTY/A="C" TID/U4=2 TERMINAL/B=0x00 MESSAGE/A="SETUP EQUIPMENT"',
    "DISPLAY_MSG_1": 'CMD/A="DISPLAY_MSG" MID/A="TRK1" MTY/A="C" TID/U4=2 TERMINAL/B=0x01 MESSAGE/A="START"',
    "DISPLAY_MSG_2": 'CMD/A="DISPLAY_MSG" MID/A="TRK1" MTY/A="E" TID/U4=2 TERMINAL/B=0x01 MESSAGE/A="THIS IS A MESSAGE FROM THE EQUIPMENT"',
    "EVENT_REPORT":   'CMD/A="EVENT_REPORT" MID/A="STP1" MTY/A="E" ECD/U4=0 ETX/A="" EVENT_ID/A="MBC_START" TIME/A="1992021115010000"',
    "EVENT_REPORT_1": 'CMD/A="EVENT_REPORT" MID/A="STP1" MTY/A="E" ECD/U4=0 ETX/A="" EVENT_ID/A="MB_COMPLETE" TIME/A="1992021115010000"',
    "EVENT_REPORT_2": 'CMD/A="EVENT_REPORT" MID/A="STP1" MTY/A="E" ECD/U4=0 ETX/A="" EVENT_ID/A="MB_COMPLETE" FILE/A="\DIR\MB_COMPLETE.001"',
    "EVENT_REPORT_3": 'CMD/A="EVENT_REPORT" MID/A="STP1" MTY/A="E" ECD/U4=30013 ETX/A="VFEI_UNEXPECTED_EVENT"',
    "EVENT_SETUP":   'CMD/A="EVENT_SETUP" MID/A="STP1" MTY/A="C" TID/U4=5 ENABLE/U1=1 EVENT_ID/A="MB_START" VAR_ID/A="CLOCK"',
    "EVENT_SETUP_1": 'CMD/A="EVENT_SETUP" MID/A="STP1" MTY/A="C" TID/U4=6 ENABLE/U1=0 CMD/A="EVENT_SETUP" MID/A="STP1" MTY/A="C" TID/U4=6 ENABLE/U1=1 EVENT_ID/A[2]=["MB_START"  "MBC_START"]',
    "EVENT_SETUP_2": 'CMD/A="EVENT_SETUP" MID/A="STP1" MTY/A="C" TID/U4=6 ENABLE/U1=0 EVENT_ID/A="MB_START"',
    "EVENT_SETUP_3": 'CMD/A="EVENT_SETUP" MID/A="STP1" MTY/A="C" TID/U4=6 ENABLE/U1=1 EVENT_ID/A="MB_START" VAR_ID/A="CLOCK" DIR/A="\usr\stp1\temp"',
    "INITIALIZE": 'CMD/A="INITIALIZE" MID/A="TRK1" MTY/A="C" TID/U4=7',
    "MACH_CMD":   'CMD/A="MACH_CMD" MID/A="TRK1" MTY/A="C" TID/U4=2 CMD_TYPE/A="LOOPBACK"',
    "MACH_CMD_1": 'CMD/A="MACH_CMD" MID/A="TRK1" MTY/A="C" TID/U4=8 CMD_TYPE/A="HELLO"',
    "MOVE":    'CMD/A="MOVE" MID/A="STOCKER1" MTY/A="C" TID/U4=2 TG_TYPE/A="POD" TG_ID/A="POD1" SRC_LOCATION/A="LOC123" DEST_LOCATION/A="STOCKER2"',
    "MOVE_1":  'CMD/A="MOVE" MID/A="MCS1" MTY/A="C" TID/U4=2 TG_TYPE/A="" TG_ID/A="12345-00000" SRC_LOCATION/A="STOCKER1" DEST_LOCATION/A="STOCKER2" SRC_PORT/A="INPUT-PORT" DEST_PORT/A="OUTPUT-PORT"',
    "MOVE_2":  'CMD/A="MOVE" MID/A="TRACK" MTY/A="C" TID/U4=2 TG_TYPE/A="CAR" TG_ID/A="CAR1"',
    "PAUSE":   'CMD/A="PAUSE" MID/A="TRK1" MTY/A="C" TID/U4=2',
    "PAUSE_1": 'CMD/A="PAUSE" MID/A="TRK1" MTY/A="C" TID/U4=2 STATION/U1=1',
    "RES_ACTIVATE":   'CMD/A="RES_ACTIVATE" MID/A="TRK1" MTY/A="C" TID/U4=10 TYPE/A="RECIPE" RES_ID/A="110232"',
    "RES_ACTIVATE_1": 'CMD/A="RES_DEACTIVATE" MID/A="TRK1" MTY/A="C" TID/U4=10 TYPE/A="RECIPE" RES_ID/A="110232"',
    "RES_DELETE":  'CMD/A="RES_DELETE" MID/A="TRK1" MTY/A="C" TID/U4=10 TYPE/A="RECIPE" RES_ID/A="110232"',
    "RES_LIST":    'CMD/A="RES_LIST" MID/A="STP1" MTY/A="R" TID/U4=14 ECD/U4=0 ETX/A="" TYPE/A="RECIPE" RES_ID/A[2]=["RECIPE1" "RECIPE2"]',
    "RES_LIST_1":  'CMD/A="RES_LIST" MID/A="STP1" MTY/A="R" TID/U4=15 ECD/U4=50020 ETX/A="Not all resource IDs exist" TYPE/A="RECIPE" RES_ID/A="RECIPE1"',
    "RES_QUERY":   'CMD/A="RES_QUERY" MID/A="STP1" MTY/A="C" TID/U4=12 TYPE/A="RECIPE"',
    "RES_QUERY_1": 'CMD/A="RES_QUERY" MID/A="STP1" MTY/A="C" TID/U4=12 TYPE/A="RECIPE" RES_ID/A[2]=["7892" "RECIPE1"]',
    "RES_REQUEST": 'CMD/A="RES_REQUEST" MID/A="STP1" MTY/A="C" TID/U4=11 TYPE/A="RECIPE" RES_ID/A="RECIPE1"',
    "RES_REQUEST_1":  'CMD/A="RES_REQUEST" MID/A="STP1" MTY/A="C" TID/U4=12 TYPE/A="RECIPE" RES_ID/A="BIG_RECIPE" RES_FILE/A="/usr/recipes/big_recipe.dat"',
    "RES_TRANSFER":   'CMD/A="RES_TRANSFER" MID/A="STP1" MTY/A="C" TID/U4=11 TYPE/A="RECIPE" RES_ID/A="RECIPE1" RES_LENGTH/U4=9 RES_BODY/B[9]=[0x01 0x02 0x03 0x04 0x05 0x06 0x07 0x08 0x09]',
    "RES_TRANSFER_1": 'CMD/A="RES_TRANSFER" MID/A="STP1" MTY/A="R" TID/U4=12 ECD/U4=0 ETX/A="" TYPE/A="RECIPE" RES_ID/A="BIG_RECIPE" RES_FILE/A="/usr/recipes/big_recipe.dat"',
    "RESTART":  'CMD/A="RESTART" MID/A="STP1" MTY/A="E" ECD/U4=0 ETX/A=""',
    "RESUME":   'CMD/A="RESUME" MID/A="TRK1" MTY/A="C" TID/U4=2',
    "RESUME_1": 'CMD/A="RESUME" MID/A="TRK1" MTY/A="C" TID/U4=2 STATION/U1=1',
    "SET_PARAM":   'CMD/A="SET_PARAM" MID/A="TRK1" MTY/A="C" TID/U4=21 TYPE/A="RECIPE" X_FOCUS/F4=0.5',
    "SET_PARAM_1": 'CMD/A="SET_PARAM" MID/A="TRK1" MTY/A="C" TID/U4=21 TYPE/A="VFEI" DEBUG/U1=2 VERBOSE/U1=3',
    "START":   'CMD/A="START" MID/A="TRK1" MTY/A="C" TID/U4=2',
    "START_1": 'CMD/A="START" MID/A="TRK1" MTY/A="C" TID/U4=2 INPUT_LOC/U1=2 MBC_SIZE/U1=0',
    "STATUS_LIST":    'CMD/A="STATUS_LIST" MID/A="STP1" MTY/A="R" TID/U4=1 ECD/U4=0 ETX/A="" PP_EXEC_NAME/A="RECIPE1"',
    "STATUS_LIST_1":  'CMD/A="STATUS_LIST" MID/A="STP1" MTY/A="R" TID/U4=1 ECD/U4=50020 ETX/A="Not all variable IDs were valid" MB_ID/A="WAFER1"',
    "STATUS_QUERY":   'CMD/A="STATUS_QUERY" MID/A="TRK1" MTY/A="C" TID/U4=2 VAR_ID/A="PP_EXEC_NAME"',
    "STATUS_QUERY_1": 'CMD/A="STATUS_QUERY" MID/A="TRK1" MTY/A="C" TID/U4=2 VAR_ID/A[2]=["MB_ID" "CLOCK"]',
    "TRACE_REPORT":   'CMD/A="TRACE_REPORT" MID/A="STP1" MTY/A="E" ECD/U4=0 ETX/A="" TRACE_ID/U2=1 REPORT_SIZE/U2=1 TEMP/I2=120',
    "TRACE_REPORT_1": 'CMD/A="TRACE_REPORT" MID/A="STP1" MTY/A="E" ECD/U4=0 ETX/A="" TRACE_ID/U2=2 REPORT_SIZE/U2=2 PRESSURE/U4[2]=[760 759]',
    "TRACE_SETUP":   'CMD/A="TRACE_SETUP" MID/A="TRK1" MTY/A="C" TID/U4=2 ENABLE/U1=1 TRACE_ID/U2=1 FREQUENCY/U4=60 SAMPLES/U2=120 REPORT_SIZE/U2=1 VAR_ID/A="TEMP"',
    "TRACE_SETUP_1": 'CMD/A="TRACE_SETUP" MID/A="TRK1" MTY/A="C" TID/U4=2 ENABLE/U1=1 TRACE_ID/U2=1 FREQUENCY/U4=10 SAMPLES/U2=60 REPORT_SIZE/U2=2 VAR_ID/A="PRESSURE"'
}

_start_cmd = 'start "PORT1" "LOT-777" "rcp567890" 25 "1111111111111111111111111" [["Param1" "U2" "100"] ["Param2" "I4" "-10"]]'
_vfei_res_act = 'CMD/A="RES_ACTIVATE" MID/A="TRK1" MTY/A="C" TID/U4=10 TYPE/A="RECIPE" RES_ID/A="110232"'

_umlToInteger = {"L": 0, "B": 010, "BOOLEAN": 011, "A": 020, "J": 021,
                 "I1": 031, "I2": 032, "I4": 034, "I8": 030,
                 "U1": 051, "U2": 052, "U4": 054, "U8": 050,
                 "F4": 044, "F8": 040}

def parse_parameters(parvect):
    pv = hostsim.ParamVector()
    for param in parvect:
        if len(param) == 3:
            try:
                format = _umlToInteger[param[1]]
                p = hostsim.Parameter(param[0], format, param[2])
                pv.append(p)
            except KeyError:
                print "Illegal format(uml):", param
                return None
        else:
            print "Illegal parameter format:", param
            return None
    return pv


class Console(cmd.Cmd):
    prompt = 'HOSTSIM> '
    hsm = hostsim.EquipmentManager()
    port = "PORT1"

    def help_begin(self):
        print "begin: begin host simulator"
    def do_begin(self, rest):
        print self.hsm.begin()

    def help_quit(self):
        print "quit: exits the command loops"
    def do_quit(self, rest):
        self.hsm.quit()
        return 1

    def help_initialize(self):
        print "initialize: start to communicate equipment"
    def do_initialize(self, rest):
        self.hsm.initialize(mid)

    def help_abort(self):
        print "abort: abort process at equipment"
        print "abort level [port-id]"
    def do_abort(self, rest):
        param = rest.split()
        if len(param) < 1:
            print "need parameter: level port-id"
        else:
            try:
                level = int(param[0])
                portid = self.port
                if len(param) == 2:
                    portid = param[1]
                self.hsm.abort(mid, portid, level)
            except TypeError:
                print "Illegal level number"

    def help_alarm_setup(self):
        print "alarm_setup: setup alarm at equipment"
        print "alarm_setup aled [alids]"
    def do_alarm_setup(self, rest):
        param = rest.split(None, 1)
        if len(param) < 1:
            print "need parameter: aled [alids]"
        else:
            if param[0].lower() == "true":
                aled = True
            elif param[0].lower() == "false":
                aled = False
            else:
                print "aled is true or false"
                aled = False
            alids = hostsim.Ids()
            if len(param) == 2:
                ids = param[1].split()
                if ids[0].lower() != "all":
                    for i in ids:
                        alids[:] = hostsim.Id(i)
            self.hsm.alarm_setup(mid, aled, alids)

    def help_display(self):
        print "display: display message at equipment"
    def do_display(self, rest):
        param = rest.split(None, 1)
        if len(param) < 1:
            print "need parameter: term-id [message]"
        else:
            try:
                termid = int(param[0])
                message = ""
                if len(param) == 2:
                    message = param[1]
                self.hsm.display(mid, termid, message)
            except TypeError:
                print "Illegal terminal id type"

    def help_event_setup(self):
        print "event_setup: setup event at equipment"
    def do_event_setup(self, rest):
        param = rest.split(None, 1)
        if len(param) < 1:
            print "need parameter: ceed [ceids]"
        else:
            if param[0].lower() == "true":
                ceed = True
            elif param[0].lower() == "false":
                ceed = False
            else:
                print "ceed is true or false"
                ceed = False
            ceids = []
            if len(param) == 2:
                ceids = param[1].split()
                if ceids[1].lower() == "all":
                    ceids = []
            self.hsm.event_setup(mid, ceed, ceids)

    def help_machine_command(self):
        print "machine_command: do command at equipment"
    def do_machine_command(self, rest):
        param = rest.split(None, 1)
        if len(param) < 1:
            print "need parameter: type [args]"
        else:
            type = param[0]
            args = []
            if len(param) == 2:
                args = param[1].split(',')
            self.hsm.machine_command(mid, type, args)

    def help_move_command(self):
        print "move_command: move material at equipment"
    def do_move_command(self, rest):
        param = rest.split()
        if len(param) < 6:
            print "need parameter: tgtype tgid src-loc dst-loc src-port dst-port"
        else:
            tgtype = param[0]
            tgid = param[1]
            src_loc = param[2]
            dst_loc = param[3]
            src_port = param[4]
            dst_port = param[5]
            self.hsm.move_command(mid, tgtype, tgid, src_loc, dst_loc,
                                  src_port, dst_port)

    def help_pause(self):
        print "pause: pause process at equipment"
    def do_pause(self, rest):
        param = rest.split()
        if len(param) < 1:
            print "need parameter: port-id"
        else:
            self.hsm.pause(mid, param[0])

    def help_res_activate(self):
        print "res_activate: activate resource at equipment"
    def do_res_activate(self, rest):
        param = rest.split(None, 1)
        if len(param) < 2:
            print "need parameter: type resids"
        else:
            restype = param[0]
            if (restype.lower() == "recipe" or
                restype.lower() == "tool" or
                restype.lower() == "component" or
                restype.lower() == "consumable" or
                restype.lower() == "cassette_map" or
                restype.lower() == "wafer_map"):
                resids = param[1].split()
                self.hsm.res_activate(mid, restype, resids)
            else:
                print "resource type is recipe, tool, component, consumable, cassette_map or wafer_map"

    def help_res_deactivate(self):
        print "res_deactivate: deactivate resource at equipment"
    def do_res_deactivate(self, rest):
        param = rest.split(None, 1)
        if len(param) < 2:
            print "need parameter: type resids"
        else:
            restype = param[0]
            if (restype.lower() == "recipe" or
                restype.lower() == "tool" or
                restype.lower() == "component" or
                restype.lower() == "consumable" or
                restype.lower() == "cassette_map" or
                restype.lower() == "wafer_map"):
                resids = param[1].split()
                self.hsm.res_deactivate(mid, restype, resids)
            else:
                print "resource type is recipe, tool, component, consumable, cassette_map or wafer_map"

    def help_res_delete(self):
        print "res_delete: delete resource at equipment"
    def do_res_delete(self, rest):
        param = rest.split(None, 1)
        if len(param) < 2:
            print "need parameter: type resids"
        else:
            restype = param[0]
            if (restype.lower() == "recipe" or
                restype.lower() == "tool" or
                restype.lower() == "component" or
                restype.lower() == "consumable" or
                restype.lower() == "cassette_map" or
                restype.lower() == "wafer_map"):
                resids = param[1].split()
                self.hsm.res_delete(mid, restype, resids)
            else:
                print "resource type is recipe, tool, component, consumable, cassette_map or wafer_map"

    def help_res_query(self):
        print "res_query: query resource at equipment"
    def do_res_query(self, rest):
        param = rest.split(None, 2)
        if len(param) < 3:
            print "need parameter: type file resids"
        else:
            restype = param[0]
            if (restype.lower() == "recipe" or
                restype.lower() == "tool" or
                restype.lower() == "component" or
                restype.lower() == "consumable" or
                restype.lower() == "cassette_map" or
                restype.lower() == "wafer_map"):
                file = param[1]
                resids = param[2].split()
                self.hsm.res_query(mid, restype, resids, file)
            else:
                print "resource type is recipe, tool, component, consumable, cassette_map or wafer_map"

    def help_res_request(self):
        print "res_request: request resource at equipment"
    def do_res_request(self, rest):
        param = rest.split(None, 2)
        if len(param) < 3:
            print "need parameter: type file resids"
        else:
            restype = param[0]
            if (restype.lower() == "recipe" or
                restype.lower() == "tool" or
                restype.lower() == "component" or
                restype.lower() == "consumable" or
                restype.lower() == "cassette_map" or
                restype.lower() == "wafer_map"):
                file = param[1]
                resids = param[2].split()
                self.hsm.res_request(mid, restype, resids, file)
            else:
                print "resource type is recipe, tool, component, consumable, cassette_map or wafer_map"

    def help_res_transfer(self):
        print "res_transfer: transfer resource at equipment"
    def do_res_transfer(self, rest):
        param = rest.split(None, 2)
        if len(param) < 3:
            print "need parameter: type resid body"
        else:
            restype = param[0]
            if (restype.lower() == "recipe" or
                restype.lower() == "tool" or
                restype.lower() == "component" or
                restype.lower() == "consumable" or
                restype.lower() == "cassette_map" or
                restype.lower() == "wafer_map"):
                resid = param[1]
                body = param[2]
                self.hsm.res_transfer(mid, restype, resid, body)
            else:
                print "resource type is recipe, tool, component, consumable, cassette_map or wafer_map"

    def help_resume(self):
        print "resume: resume process at equipment"
    def do_resume(self, rest):
        param = rest.split()
        if len(param) < 1:
            print "need parameter: port-id"
        else:
            self.hsm.resume(mid, param[0])

    def help_set_param(self):
        print "set_param: set param at equipment"
    def do_set_param(self, rest):
        param = rest.split(None, 1)
        if len(param) < 1:
            print "need parameter: type [args]"
        else:
            type = param[0]
            if (restype.lower() == "recipe" or
                restype.lower() == "tool" or
                restype.lower() == "component" or
                restype.lower() == "consumable" or
                restype.lower() == "machine" or
                restype.lower() == "vfei"):
                args = []
                if len(param) == 2:
                    args = param[1].split(',')
                self.hsm.set_param(mid, type, args)
            else:
                print "resource type is recipe, tool, component, consumable, machine or vfei"

    def help_start(self):
        print("start: start process at equipment:" +
              "start port lotid ppid lotsize wafer_map params")
    def do_start(self, rest):
        param = rest.split(" ", 4)
        if len(param) < 4:
            print "not enough parameter count"
        else:
            portid = param[0]
            lotid = param[1]
            ppid = param[2]
            wafer_map = param[3]
            size = len(wafer_map)
            args = []
            if len(param) == 5:
                args = param[4].split(',')
            self.hsm.start(mid, portid, lotid, ppid, size, wafer_map, args)

    def help_status_query(self):
        print "status_query: query status at equipment"
    def do_status_query(self, rest):
        param = rest.split(None, 1)
        if len(param) < 2:
            print "need parameter: file vids"
        else:
            file = param[0]
            vids = param[1].split()
            self.hsm.status_query(mid, vids, file)

    def help_trace_setup(self):
        print "trace_setup: setup trace parameter at equipment"
    def do_trace_setup(self, rest):
        param = rest.split(" ", 6)
        if len(param) < 6:
            print "not enough parameter count"
        else:
            try:
                if param[0].lower() == "true":
                    enable = True
                elif param[0].lower() == "false":
                    enable = False
                else:
                    print "enable is true or false"
                    enable = False
                trace_id = param[1]
                frequency = param[2]
                samples = param[3]
                rpt_size = param[4]
                dir = param[5]
                args = []
                if len(param) == 7:
                    args = param[6].split()
                self.hsm.trace_setup(mid, enable, trace_id, frequency, samples,
                                     rpt_size, dir, args)
            except TypeError:
                print "Illegal type: trace-id, frequency, samples or report-size"


    def help_vfei(self):
        print "vfei: parse and do vfei message at equipment"
    def do_vfei(self, rest):
        if rest == "view":
            names = vfei_tests.keys()
            names.sort()
            for name in names:
                print name.lower()
        else:
            try:
                vfeimsg = vfei_tests[string.upper(rest)]
                self.hsm.vfei(vfeimsg)
            except KeyError:
                print "Illegal test message name"

    def help_xml(self):
        print "xml: parse and do xml message at equipment"
    def do_xml(self, rest):
        print self.hsm.xml(rest)

if __name__ == '__main__':
    Console().cmdloop()
