// $Id: JSAtom.h,v 1.4 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSAtom.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JSATOM_H
#define JSATOM_H

#include "BS2Atom.h"
#include "BS2JavaInterp.h"


#ifdef _DEBUG
#define ASSERT_JCLASS(c,n)                                                    \
            if ((c) == NULL) {                                                \
                TRACE_ERROR(("Find class error (%s)\n", (n)));                \
                throw runtime_error("Class not found");                       \
            }

#define ASSERT_METHODID(i,m,p)                                                \
            if ((i) == NULL) {                                                \
                TRACE_ERROR(("Find method error (%s => %s)\n", (m), (p)));    \
                throw runtime_error("Method not found");                      \
            }

#define ASSERT_FIELDID(i,f,t)                                                 \
            if ((i) == NULL) {                                                \
                TRACE_ERROR(("Get field error (%s : %s)\n", (f), (t)));       \
                throw runtime_error("Field not found");                       \
            }
#else
#define ASSERT_JCLASS(c,n)
#define ASSERT_METHODID(i,m,p)
#define ASSERT_FIELDID(i,f,t)
#endif

class BS2List;

//
// secs value wrapper class
//
class JSAtom
{
public:
    virtual ~JSAtom() {}

    // secs value to atom object
    virtual jobject toObj(BS2Atom * atom) = 0;

    // secs value to item object
    virtual jobject toItemObj(BS2Atom * atom, jstring itemName) = 0;

    // jobject to atom
    virtual BS2Atom * toAtom(jobject valObj) = 0;
    virtual BS2Atom * toArray(jobject arrayObj) = 0;
    virtual int       toList(jobject listObj, BS2List * listAtom) = 0;

    //
    static JSAtom * init(JNIEnv * jenv, jclass itemClass);
    static JSAtom * instance(int format);

protected:
    JSAtom() : m_jenv(NULL), m_class(NULL), m_itemClass(NULL),
               m_listClass(NULL), m_new(NULL), m_vget(NULL), m_item(NULL),
               m_array(NULL), m_listGet(NULL), m_listSize(NULL),
               m_typeFld(NULL) {}
    void initClass(JNIEnv * jenv, jclass itemClass);

protected:
    JNIEnv *  m_jenv;
    jclass    m_class;
    jclass    m_itemClass;
    jclass    m_listClass;
    jmethodID m_new;         // Construct new value
    jmethodID m_vget;
    jmethodID m_item;
    jmethodID m_array;       // Construct new array item
    jmethodID m_listGet;
    jmethodID m_listSize;
    jfieldID  m_typeFld;

};

#endif
