// $Id: JSMessage.h,v 1.4 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSMessage.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef JSMESSAGE_H
#define JSMESSAGE_H

#include "BS2Message.h"
#include "JSAtom.h"

class JSMessage
{
public:
    JSMessage() {}
    ~JSMessage() {}

    void init(JNIEnv * jenv);
    jclass getClass() { return m_class; }

    // secs message to message object
    jobject toItemObj(BS2Message * msg);

    // message object to secs message
    BS2Message * toMessage(jobject msgObj);

    // Global access method
    static JSMessage * instance();

protected:
    JNIEnv *  m_jenv;
    jclass    m_class;

    jmethodID m_new;         // SECSMessage(int sfnum);
    jmethodID m_size;
    jmethodID m_at;          // at(int i);
    jmethodID m_setList;     // set(SECSList item);
    jmethodID m_setItem;     // set(SECSItem item);

    jfieldID  m_sfnumFld;
    jfieldID  m_waitFld;
    jfieldID  m_transFld;
    jfieldID  m_userFld;
};

#endif
