// $Id: JSItem.cpp,v 1.4 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSItem.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "JSItem.h"

static char * _className = CLASSPATH  "SECSItem";
static JSItem _item;

//
JSItem * JSItem::instance()
{
    return &_item;
}

// Initialize class, method and field which is attributes of SECSItem
void JSItem::init(JNIEnv * jenv)
{
    TRACE_FUNCTION(TRL_LOW, "JSItem::init");
    m_jenv = jenv;

    m_class = jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_new = jenv->GetMethodID(m_class, "<init>", "(Ljava/lang/String;ILjava/lang/Object;)V");
    ASSERT_METHODID(m_new, "<init>", "(Ljava/lang/String;ILjava/lang/Object;)V");

    m_nameFld = jenv->GetFieldID(m_class, "m_name", "Ljava/lang/String;");
    ASSERT_FIELDID(m_nameFld, "m_name", "Ljava/lang/String;");

    m_valueFld = jenv->GetFieldID(m_class, "m_value", "Ljava/lang/Object;");
    ASSERT_FIELDID(m_valueFld, "m_value", "Ljava/lang/Object;");

    m_typeFld = jenv->GetFieldID(m_class, "m_type", "I");
    ASSERT_FIELDID(m_typeFld, "m_type", "I");

}

//
// --- object ---
//
// jobject to message item
jobject JSItem::getValue(jobject itemObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSItem::getValue");

    jobject valObj = m_jenv->GetObjectField(itemObj, m_valueFld);
    if (valObj == NULL)
    {
        TRACE_ERROR((_TX("Illegal item object (\"m_value\" not found)\n")));
    }
    return valObj;
}

// secs value to item object
jobject JSItem::toItemObj(BS2Item * item)
{
    TRACE_FUNCTION(TRL_LOW, "JSItem::toItemObj");
    jobject obj;
    if (item != NULL)
    {
        jstring itemName = m_jenv->NewStringUTF(item->charName());
        BS2Atom * atom = item->atom();
        int format = atom->format();

        obj = JSAtom::instance(format)->toItemObj(atom, itemName);
    }
    else
    {
        obj = NULL;
    }
    return obj;
}

// jobject to message item
BS2Item * JSItem::toItem(jobject obj)
{
    TRACE_FUNCTION(TRL_LOW, "JSItem::toItem");
    BS2Item * item;

    if (obj != NULL)
    {
        jobject valObj = m_jenv->GetObjectField(obj, m_valueFld);
        // Item name
        jstring itemName = reinterpret_cast<jstring>
                               (m_jenv->GetObjectField(obj, m_nameFld));
        if (itemName == NULL)
        {
            TRACE_ERROR((_TX("Illegal object (\"m_name\" not found)\n")));
            return NULL;
        }
        // Format of value
        jint type = m_jenv->GetIntField(obj, m_typeFld);

        // Make atom by format
        BS2Atom * atom;
        if ((type & ATOM_ARRAY) == 0)
        {
            atom = JSAtom::instance(type)->toAtom(valObj);
        }
        else
        {
            atom = JSAtom::instance(type)->toArray(valObj);
        }
        // Make item
        jboolean isCopy0;
        const char * iname = m_jenv->GetStringUTFChars(itemName, &isCopy0);
        item = BS2Item::factory(iname, atom);
        if (isCopy0 == JNI_TRUE)
        {
             m_jenv->ReleaseStringUTFChars(itemName, iname);
        }
    }
    else
    {
        item = NULL;
    }
    return item;
}

