// $Id: JSAscii.cpp,v 1.5 2004/06/20 15:23:40 fukasawa Exp $

//=============================================================================
/**
 *  @file    JSAscii.cpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2004 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#define BEE_BUILD_DLL

#include "BS2List.h"
#include "JSAscii.h"

static const char * _className = "java/lang/String";

void JSAscii::init(JNIEnv * jenv, jclass itemClass)
{
    TRACE_FUNCTION(TRL_LOW, "JSAscii::init");

    initClass(jenv, itemClass);

    m_class = jenv->FindClass(_className);
    ASSERT_JCLASS(m_class, _className);

    m_vget = m_jenv->GetMethodID(itemClass, "toString", "()Ljava/lang/String;");
    ASSERT_METHODID(m_vget, "toString", "()Ljava/lang/String;");

    m_new = jenv->GetMethodID(m_class, "<init>",
                                       "(Ljava/lang/String;)V");
    ASSERT_METHODID(m_new, "<init>", "(Ljava/lang/String;)V");

    m_item = m_jenv->GetMethodID(itemClass,
                                 "<init>",
                                 "(Ljava/lang/String;Ljava/lang/String;)V");
    ASSERT_METHODID(m_item, "<init>",
                            "(Ljava/lang/String;Ljava/lang/String;)V");
}

// secs value to atom object
jobject JSAscii::toObj(BS2Atom * atom)
{
    TRACE_FUNCTION(TRL_LOW, "JSAscii::toObj");
    BS2Ascii * ascii = reinterpret_cast<BS2Ascii *>(atom);
    jstring valStr = m_jenv->NewStringUTF(ascii->value().c_str());
    jobject obj = m_jenv->NewObject(m_class, m_new, valStr);
    return obj;
}

// secs value to item object
jobject JSAscii::toItemObj(BS2Atom * atom, jstring itemName)
{
    TRACE_FUNCTION(TRL_LOW, "JSAscii::toItemObj");

    BS2Ascii * ascii = reinterpret_cast<BS2Ascii *>(atom);
    jstring valStr = m_jenv->NewStringUTF(ascii->value().c_str());
    return m_jenv->NewObject(m_itemClass, m_item, itemName, valStr);
}

// jobject to secs value
BS2Atom * JSAscii::toAtom(jobject valObj)
{
    TRACE_FUNCTION(TRL_LOW, "JSAscii::toAtom");
    BS2Atom * atom;

    if (valObj != NULL)
    {
        jstring strval =
            reinterpret_cast<jstring>(m_jenv->CallObjectMethod(valObj, m_vget));
        jboolean isCopy0;
        const char * str = m_jenv->GetStringUTFChars(strval, &isCopy0);
        atom = new BS2Ascii(str);
        if (isCopy0 == JNI_TRUE)
        {
            m_jenv->ReleaseStringUTFChars(strval, str);
        }
    }
    else
    {
        atom = new BS2Ascii();
    }
    return atom;
}

// jobject to secs list
int JSAscii::toList(jobject valObj, BS2List * listAtom)
{
    TRACE_FUNCTION(TRL_LOW, "JSAscii::toList");

    jint len = m_jenv->CallIntMethod(valObj, m_listSize);
    for (int i = 0; i < len; i++)
    {
        jstring mbrStr = reinterpret_cast<jstring>(
                             m_jenv->CallObjectMethod(valObj, m_listGet, i));
        jboolean isCopy;
        const char * val = m_jenv->GetStringUTFChars(mbrStr, &isCopy);
        BS2Atom * atom = new BS2Ascii(val);
        listAtom->add(*atom);
        delete atom;
        if (isCopy == JNI_TRUE)
        {
            m_jenv->ReleaseStringUTFChars(mbrStr, val);
        }
    }
    return 0;
}
