/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.analyze.binder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.stormcat.commons.constants.Charset;
import org.stormcat.commons.lang.StringUtil;
import org.stormcat.commons.reflect.ClassUtil;
import org.stormcat.commons.reflect.MethodUtil;
import org.stormcat.jvbeans.exception.JvBeansRuntimeException;
import org.stormcat.jvbeans.jvlink.analyze.JvBindingObjectConverter;
import org.stormcat.jvbeans.jvlink.analyze.JvRecordMeta;
import org.stormcat.jvbeans.jvlink.analyze.binder.JvDataBinder;
import org.stormcat.jvbeans.util.JvStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvStandardDataBinder
extends JvDataBinder {
    public JvStandardDataBinder() {
        super(null);
    }

    @Override
    public <T> void bindProperty(List<JvRecordMeta> metaItems, T dto, String data) {
        byte[] bt = StringUtil.getBytes((String)data, (Charset)Charset.MS932);
        this.bindProperty(metaItems, dto, bt);
    }

    private <T> void bindProperty(List<JvRecordMeta> metaItems, T dto, byte[] bt) {
        for (JvRecordMeta meta : metaItems) {
            byte[] parts = null;
            List<JvRecordMeta> joinItems = meta.getJoinMetaItems();
            if (meta.getRepeatCount() == 1) {
                parts = this.subarray(bt, meta.getPosition(), meta.getByteLength());
                this.setProperty(parts, meta, dto);
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < meta.getRepeatCount()) {
                Object child = null;
                parts = this.subarray(bt, i * meta.getByteLength() + meta.getPosition(), meta.getByteLength());
                if (joinItems == null) {
                    child = this.convert(parts, meta);
                } else {
                    child = ClassUtil.newInstance(meta.getType());
                    this.bindProperty(joinItems, child, parts);
                }
                list.add(child);
                ++i;
            }
            MethodUtil.invoke((Method)meta.getMutator(), dto, null, (Object[])new Object[]{list});
        }
    }

    private Object convert(byte[] data, JvRecordMeta meta) {
        String rawData = JvStringUtil.trim(StringUtil.getString((byte[])data, (Charset)Charset.MS932));
        return JvBindingObjectConverter.convert(rawData, meta);
    }

    private void setProperty(byte[] data, JvRecordMeta meta, Object target) {
        Object value = this.convert(data, meta);
        Method mutator = meta.getMutator();
        if (mutator == null) {
            throw new JvBeansRuntimeException("\u30bb\u30c3\u30bf\u30fc\u30e1\u30bd\u30c3\u30c9\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        MethodUtil.invoke((Method)mutator, (Object)target, null, (Object[])new Object[]{value});
    }

    private byte[] subarray(byte[] data, int position, int byteLength) {
        return ArrayUtils.subarray((byte[])data, (int)(position - 1), (int)(position + byteLength - 1));
    }
}

