/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.analyze.binder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.stormcat.commons.constants.FileExtension;
import org.stormcat.commons.reflect.ClassUtil;
import org.stormcat.commons.reflect.MethodUtil;
import org.stormcat.jvbeans.exception.JvBeansRuntimeException;
import org.stormcat.jvbeans.jvlink.analyze.JvBindingObjectConverter;
import org.stormcat.jvbeans.jvlink.analyze.JvRecordMeta;
import org.stormcat.jvbeans.jvlink.analyze.binder.JvDataBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JvIncludeSeparatorDataBinder
extends JvDataBinder {
    protected JvIncludeSeparatorDataBinder(FileExtension inputType) {
        super(inputType);
    }

    @Override
    public <T> void bindProperty(List<JvRecordMeta> metaItems, T dto, String data) {
        String[] records = data.split(this.getSeparator());
        int index = 0;
        for (JvRecordMeta meta : metaItems) {
            List<JvRecordMeta> joinItems = meta.getJoinMetaItems();
            if (meta.getRepeatCount() == 1) {
                this.setProperty(this.removeQuote(records[index++]), meta, dto);
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < meta.getRepeatCount()) {
                Object child = null;
                if (joinItems == null) {
                    child = JvBindingObjectConverter.convert(this.removeQuote(records[index++]), meta);
                } else {
                    child = ClassUtil.newInstance(meta.getType());
                    int length = this.getChildRecordLength(joinItems);
                    this.bindProperty(joinItems, child, this.construct(records, index, length));
                    index += length;
                }
                list.add(child);
                ++i;
            }
            MethodUtil.invoke((Method)meta.getMutator(), dto, null, (Object[])new Object[]{list});
        }
    }

    private int getChildRecordLength(List<JvRecordMeta> joinItems) {
        int length = 0;
        for (JvRecordMeta meta : joinItems) {
            length += meta.getRepeatCount();
        }
        return length;
    }

    private String construct(String[] data, int index, int length) {
        StringBuilder builder = new StringBuilder();
        int i = index;
        while (i < index + length) {
            builder.append(data[i]);
            if (i < index + length - 1) {
                builder.append(this.getSeparator());
            }
            ++i;
        }
        return builder.toString();
    }

    private void setProperty(String data, JvRecordMeta meta, Object target) {
        Object value = JvBindingObjectConverter.convert(data, meta);
        Method mutator = meta.getMutator();
        if (mutator == null) {
            throw new JvBeansRuntimeException("\u30bb\u30c3\u30bf\u30fc\u30e1\u30bd\u30c3\u30c9\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        MethodUtil.invoke((Method)mutator, (Object)target, null, (Object[])new Object[]{value});
    }

    private String removeQuote(String data) {
        return data.substring(1, data.length() - 1);
    }

    protected abstract String getSeparator();
}

