/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink;

import java.util.Iterator;
import org.stormcat.commons.constants.FileExtension;
import org.stormcat.commons.lang.ThreadUtil;
import org.stormcat.commons.reflect.ClassUtil;
import org.stormcat.jvbeans.config.condition.OpenCondition;
import org.stormcat.jvbeans.config.condition.StoredOpenCondition;
import org.stormcat.jvbeans.exception.JvBeansRuntimeException;
import org.stormcat.jvbeans.jvlink.JvBindingDto;
import org.stormcat.jvbeans.jvlink.JvLinkExceptionHandler;
import org.stormcat.jvbeans.jvlink.JvLinkManager;
import org.stormcat.jvbeans.jvlink.JvLinkManagerImpl;
import org.stormcat.jvbeans.jvlink.JvReader;
import org.stormcat.jvbeans.jvlink.analyze.JvBeansContainer;
import org.stormcat.jvbeans.response.JvContents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvReaderImpl<T extends JvBindingDto>
implements JvReader<T> {
    private JvLinkManagerImpl jvLinkManager;
    private OpenCondition<T> openCondition;

    public JvReaderImpl(JvLinkManager jvLinkManager, OpenCondition<T> openCondition) {
        this.jvLinkManager = (JvLinkManagerImpl)jvLinkManager;
        this.openCondition = openCondition;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int returnCode = -1;

            @Override
            public boolean hasNext() {
                if (this.returnCode < -1) {
                    throw new JvBeansRuntimeException(String.format("\u30c7\u30fc\u30bf\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002: return code = %d", this.returnCode));
                }
                return this.returnCode != 0;
            }

            @Override
            public T next() {
                JvContents contents = this.readLine();
                this.returnCode = contents.getReturnCode();
                Object dto = contents.getBindingDto();
                if (dto == null) {
                    dto = (JvBindingDto)ClassUtil.newInstance(JvReaderImpl.this.openCondition.getType());
                }
                ((JvBindingDto)dto).setFileName(contents.getFileName());
                return dto;
            }

            @Override
            public void remove() {
                JvContents jvContents = this.readLine();
                this.returnCode = jvContents.getReturnCode();
            }

            private JvContents<T> readLine() {
                if (JvReaderImpl.this.openCondition == null) {
                    throw new JvBeansRuntimeException("JVOpen\u304c\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                }
                return this.readContents(JvReaderImpl.this.openCondition);
            }

            private JvContents<T> readContents(OpenCondition<T> condition) {
                JvContents contents = null;
                JvBeansContainer container = JvReaderImpl.this.jvLinkManager.getJvBeansContainer();
                int result = -1;
                while (result != 0) {
                    contents = this.read(container.getRecordByteLength(condition.getRecordTypeId()));
                    result = contents.getReturnCode();
                    if (result < -1) {
                        if (result == -3) {
                            ThreadUtil.sleep((long)1000L);
                            continue;
                        }
                        JvLinkExceptionHandler.handleException(contents);
                    }
                    if (contents.startWith(condition.getRecordTypeId()) && !contents.isEmpty()) {
                        contents.setBindingDto(JvReaderImpl.this.jvLinkManager.getJvBindingDtoFactory().create(contents.toString(), JvReaderImpl.this.openCondition));
                        break;
                    }
                    if (!(condition instanceof StoredOpenCondition)) continue;
                    JvReaderImpl.this.jvLinkManager.skip();
                }
                return contents;
            }

            private JvContents<T> read(int length) {
                return JvReaderImpl.this.jvLinkManager.getJvLinkWrapper().jvRead(length);
            }
        };
    }

    @Override
    public void setOutputType(FileExtension outputType) {
    }

    @Override
    public FileExtension getOutputType() {
        return null;
    }
}

