/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink;

import java.io.File;
import java.util.Date;
import java.util.regex.Pattern;
import org.stormcat.commons.constants.Charset;
import org.stormcat.commons.lang.DateUtil;
import org.stormcat.commons.lang.StringUtil;
import org.stormcat.jvbeans.config.DataOption;
import org.stormcat.jvbeans.config.condition.RealTimeOpenCondition;
import org.stormcat.jvbeans.config.condition.StoredOpenCondition;
import org.stormcat.jvbeans.config.key.CourseFileKey;
import org.stormcat.jvbeans.config.key.RtOpenKey;
import org.stormcat.jvbeans.jvlink.JvBindingDto;
import org.stormcat.jvbeans.jvlink.JvBindingDtoReader;
import org.stormcat.jvbeans.jvlink.JvLinkExceptionHandler;
import org.stormcat.jvbeans.jvlink.JvLinkManager;
import org.stormcat.jvbeans.jvlink.JvLinkWrapper;
import org.stormcat.jvbeans.jvlink.JvLinkWrapperImpl;
import org.stormcat.jvbeans.jvlink.JvReader;
import org.stormcat.jvbeans.jvlink.JvSimpleReader;
import org.stormcat.jvbeans.jvlink.analyze.JvBeansContainer;
import org.stormcat.jvbeans.jvlink.analyze.JvBindingDtoFactory;
import org.stormcat.jvbeans.response.JvCourseFile;
import org.stormcat.jvbeans.response.JvOpen;
import org.stormcat.jvbeans.response.JvResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvLinkManagerImpl
implements JvLinkManager {
    private static final int MAX_BYTE_LENGTH_USER_AGENT = 64;
    private static final String JV_DATE_FORMAT = "yyyyMMddHHmmss";
    private String userAgent = "UNKNOWN";
    private JvLinkWrapper jvLinkWrapper = new JvLinkWrapperImpl();
    private JvBeansContainer jvBeansContainer;
    private JvBindingDtoFactory jvBindingDtoFactory;

    @Override
    public void cancel() {
        this.jvLinkWrapper.jvCancel();
    }

    @Override
    public JvResult close() {
        JvResult result = this.jvLinkWrapper.jvClose();
        JvLinkExceptionHandler.handleException(result);
        return result;
    }

    @Override
    public JvResult fileDelete(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u540d\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        JvResult result = this.jvLinkWrapper.jvFileDelete(fileName);
        JvLinkExceptionHandler.handleException(result);
        return result;
    }

    @Override
    public JvResult fukuFile(String pattern, String filePath) {
        if (pattern == null) {
            throw new IllegalArgumentException("\u670d\u8272\u6a19\u793a\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("\u4fdd\u5b58\u30d1\u30b9\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        if (!new File(filePath).exists()) {
            throw new IllegalArgumentException("\u4fdd\u5b58\u30d1\u30b9\u306f\u5b9f\u969b\u306b\u5b58\u5728\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        JvResult result = this.jvLinkWrapper.jvFukuFile(pattern, filePath);
        JvLinkExceptionHandler.handleException(result);
        return result;
    }

    @Override
    public JvResult init() {
        JvResult result = this.jvLinkWrapper.jvInit(this.getUserAgent());
        JvLinkExceptionHandler.handleException(result);
        return result;
    }

    @Override
    public <T extends JvBindingDto> JvReader<T> open(StoredOpenCondition<T> condition, Date fromTime, DataOption dataOption) {
        if (fromTime == null) {
            throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u8aad\u307f\u51fa\u3057\u958b\u59cb\u30dd\u30a4\u30f3\u30c8\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        return this.open(condition, DateUtil.formatDate((Date)fromTime, (String)JV_DATE_FORMAT), dataOption);
    }

    @Override
    public <T extends JvBindingDto> JvReader<T> open(StoredOpenCondition<T> condition, String fromTime, DataOption dataOption) {
        if (condition == null) {
            throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u691c\u7d22\u6761\u4ef6\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        if (fromTime == null) {
            throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u8aad\u307f\u51fa\u3057\u958b\u59cb\u30dd\u30a4\u30f3\u30c8\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        if (dataOption == null) {
            dataOption = DataOption.STANDARD;
        }
        JvOpen jvOpen = this.jvLinkWrapper.jvOpen((String)condition.getDataSpec().getValue(), fromTime, dataOption.getValue().intValue());
        JvLinkExceptionHandler.handleException(jvOpen);
        return new JvBindingDtoReader<T>(this, condition);
    }

    @Override
    public <T extends JvBindingDto> JvReader<String> simpleOpen(StoredOpenCondition<T> condition, Date fromTime, DataOption dataOption) {
        if (fromTime == null) {
            throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u8aad\u307f\u51fa\u3057\u958b\u59cb\u30dd\u30a4\u30f3\u30c8\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        return this.simpleOpen(condition, DateUtil.formatDate((Date)fromTime, (String)JV_DATE_FORMAT), dataOption);
    }

    @Override
    public <T extends JvBindingDto> JvReader<String> simpleOpen(StoredOpenCondition<T> condition, String fromTime, DataOption dataOption) {
        if (condition == null) {
            throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u691c\u7d22\u6761\u4ef6\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        if (fromTime == null) {
            throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u8aad\u307f\u51fa\u3057\u958b\u59cb\u30dd\u30a4\u30f3\u30c8\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        if (dataOption == null) {
            dataOption = DataOption.STANDARD;
        }
        JvOpen jvOpen = this.jvLinkWrapper.jvOpen((String)condition.getDataSpec().getValue(), fromTime, dataOption.getValue().intValue());
        JvLinkExceptionHandler.handleException(jvOpen);
        return new JvSimpleReader<T>(this, condition);
    }

    @Override
    public <T extends JvBindingDto> JvReader<T> rtOpen(RealTimeOpenCondition<T> condition, RtOpenKey rtOpenKey) {
        if (condition == null) {
            throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u691c\u7d22\u6761\u4ef6\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002\u3002");
        }
        if (rtOpenKey == null) {
            throw new IllegalArgumentException("key\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        JvOpen jvOpen = this.jvLinkWrapper.jvRtOpen((String)condition.getDataSpec().getValue(), rtOpenKey.toString());
        JvLinkExceptionHandler.handleException(jvOpen);
        return new JvBindingDtoReader<T>(this, condition);
    }

    @Override
    public <T extends JvBindingDto> JvReader<String> rtSimpleOpen(RealTimeOpenCondition<T> condition, RtOpenKey rtOpenKey) {
        if (condition == null) {
            throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u691c\u7d22\u6761\u4ef6\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002\u3002");
        }
        if (rtOpenKey == null) {
            throw new IllegalArgumentException("key\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        JvOpen jvOpen = this.jvLinkWrapper.jvRtOpen((String)condition.getDataSpec().getValue(), rtOpenKey.toString());
        JvLinkExceptionHandler.handleException(jvOpen);
        return new JvSimpleReader<T>(this, condition);
    }

    @Override
    public JvResult setSaveFlag(boolean saveFlag) {
        JvResult result = this.jvLinkWrapper.jvSetSaveFlag(saveFlag ? 1 : 0);
        JvLinkExceptionHandler.handleException(result);
        return result;
    }

    @Override
    public JvResult setSavePath(String savePath) {
        if (savePath == null) {
            throw new IllegalArgumentException("\u4fdd\u5b58\u30d1\u30b9\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        if (!new File(savePath).exists()) {
            throw new IllegalArgumentException("\u4fdd\u5b58\u30d1\u30b9\u306f\u5b9f\u969b\u306b\u5b58\u5728\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        JvResult result = this.jvLinkWrapper.jvSetSavePath(savePath);
        JvLinkExceptionHandler.handleException(result);
        return result;
    }

    @Override
    public JvResult setServiceKey(String serviceKey) {
        if (serviceKey == null) {
            throw new IllegalArgumentException("\u30b5\u30fc\u30d3\u30b9\u30ad\u30fc\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        JvResult result = this.jvLinkWrapper.jvSetServiceKey(serviceKey);
        JvLinkExceptionHandler.handleException(result);
        return result;
    }

    @Override
    public JvResult setUIProperties() {
        JvResult result = this.jvLinkWrapper.jvSetUIProperties();
        JvLinkExceptionHandler.handleException(result);
        return result;
    }

    @Override
    public void skip() {
        this.jvLinkWrapper.jvSkip();
    }

    @Override
    public long status() {
        JvResult result = this.jvLinkWrapper.jvStatus();
        JvLinkExceptionHandler.handleException(result);
        return result.getReturnCode();
    }

    @Override
    public JvCourseFile courseFile(CourseFileKey courseFileKey) {
        if (courseFileKey == null) {
            throw new IllegalArgumentException("\u30b3\u30fc\u30b9\u3092\u6307\u5b9a\u3059\u308bkey\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        JvCourseFile courceFile = this.jvLinkWrapper.jvCourseFile(courseFileKey.toString());
        JvLinkExceptionHandler.handleException(courceFile);
        return courceFile;
    }

    @Override
    public JvCourseFile courseFile2(CourseFileKey courseFileKey, String filePath) {
        if (courseFileKey == null) {
            throw new IllegalArgumentException("\u30b3\u30fc\u30b9\u3092\u6307\u5b9a\u3059\u308bkey\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        JvCourseFile courceFile = this.jvLinkWrapper.jvCourceFile2(courseFileKey.toString(), filePath);
        JvLinkExceptionHandler.handleException(courceFile);
        return courceFile;
    }

    @Override
    public void setUserAgent(String userAgent) {
        if (StringUtil.isEmpty((String)userAgent)) {
            throw new IllegalArgumentException("UserAgent\u306bnull\u3084\u7a7a\u6587\u5b57\u3092\u6307\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        int length = StringUtil.getBytesLength((String)userAgent, (Charset)Charset.MS932);
        if (length > 64) {
            throw new IllegalArgumentException(String.format("UserAgent\u306f64\u30d0\u30a4\u30c8\u4ee5\u4e0b\u3067\u306a\u3051\u308c\u3070\u3044\u3051\u307e\u305b\u3093\u3002: %s \u30d0\u30a4\u30c8", length));
        }
        if (!Pattern.matches("^[\\w\\s\\.\\/]*$", userAgent)) {
            throw new IllegalArgumentException(String.format("%s", userAgent));
        }
        this.userAgent = userAgent;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    public JvBeansContainer getJvBeansContainer() {
        return this.jvBeansContainer;
    }

    public void setJvBeansContainer(JvBeansContainer jvBeansContainer) {
        this.jvBeansContainer = jvBeansContainer;
    }

    public JvBindingDtoFactory getJvBindingDtoFactory() {
        return this.jvBindingDtoFactory;
    }

    public void setJvBindingDtoFactory(JvBindingDtoFactory jvBindingDtoFactory) {
        this.jvBindingDtoFactory = jvBindingDtoFactory;
    }

    public JvLinkWrapper getJvLinkWrapper() {
        return this.jvLinkWrapper;
    }
}

