/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink;

import java.util.Iterator;
import org.stormcat.commons.constants.FileExtension;
import org.stormcat.commons.reflect.ClassUtil;
import org.stormcat.jvbeans.config.condition.OpenCondition;
import org.stormcat.jvbeans.jvlink.JvBindingDto;
import org.stormcat.jvbeans.jvlink.JvDataIterator;
import org.stormcat.jvbeans.jvlink.JvLinkManagerImpl;
import org.stormcat.jvbeans.jvlink.JvReader;
import org.stormcat.jvbeans.jvlink.converter.JvDataConverter;
import org.stormcat.jvbeans.jvlink.converter.JvDataConverterFactory;
import org.stormcat.jvbeans.response.JvContents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvBindingDtoReader<T extends JvBindingDto>
implements JvReader<T> {
    private JvDataIterator<T> iterator;
    private JvLinkManagerImpl jvLinkManager;
    private FileExtension outputType;

    public JvBindingDtoReader(JvLinkManagerImpl jvLinkManager, OpenCondition<T> openCondition) {
        this.iterator = new JvDataIterator<T>(jvLinkManager, openCondition);
        this.jvLinkManager = jvLinkManager;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return JvBindingDtoReader.this.iterator.hasNext();
            }

            @Override
            public T next() {
                Object contents = JvBindingDtoReader.this.iterator.next();
                Class clazz = JvBindingDtoReader.this.iterator.getOpenCondition().getType();
                OpenCondition condition = JvBindingDtoReader.this.iterator.getOpenCondition();
                if (contents != null && ((JvContents)contents).startWith(condition.getRecordTypeId()) && !((JvContents)contents).isEmpty()) {
                    Object dto = JvBindingDtoReader.this.jvLinkManager.getJvBindingDtoFactory().create(((JvContents)contents).toString(), condition);
                    ((JvContents)contents).setBindingDto(dto);
                    JvDataConverter convertor = JvDataConverterFactory.createConvertor(JvBindingDtoReader.this.outputType);
                    ((JvContents)contents).setLine(convertor.convert(JvBindingDtoReader.this.jvLinkManager.getJvBeansContainer(), ((JvContents)contents).getLine()));
                    return dto;
                }
                return (JvBindingDto)ClassUtil.newInstance(clazz);
            }

            @Override
            public void remove() {
                JvBindingDtoReader.this.iterator.remove();
            }
        };
    }

    @Override
    public void setOutputType(FileExtension outputType) {
        this.outputType = outputType;
    }

    @Override
    public FileExtension getOutputType() {
        return this.outputType;
    }
}

