/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.commons.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.stormcat.commons.exception.IllegalAccessRuntimeException;
import org.stormcat.commons.exception.InvocationTargetRuntimeException;
import org.stormcat.commons.exception.NoSuchMethodRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodUtil {
    protected MethodUtil() {
    }

    public static Method getMethod(Class<?> target, String methodName, Class<?> ... parameters) {
        try {
            return target.getMethod(methodName, parameters);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(e);
        }
    }

    public static Method getDeclareMethod(Class<?> target, String methodName, Class<?> ... parameters) {
        try {
            return target.getDeclaredMethod(methodName, parameters);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(e);
        }
    }

    public static <T> T invoke(Method method, Object target, Class<T> returnType, Object ... args) {
        try {
            return (T)method.invoke(target, args);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("methodName = %s", method.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(e);
        }
    }
}

