/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.WE} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.WE, byteLength = 42)
public class WeatherTrackStateDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 開催年 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 4)
    private java.lang.Integer holdingYear;

    /** 開催月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 16, byteLength = 4)
    private java.lang.String holdingDate;

    /** 競馬場コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 20, byteLength = 2)
    private org.stormcat.jvbeans.config.code.CourseCd courseCd;

    /** 開催回[第N回] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 22, byteLength = 2)
    private java.lang.Integer holdingNo;

    /** 開催日目[N日目] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 24, byteLength = 2)
    private java.lang.Integer holdingDay;

    /** 発表月日時分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 26, byteLength = 8)
    private java.util.Date announceDate;

    /** 変更識別 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 34, byteLength = 1)
    private java.lang.Integer changeIdentification;

    /** 天候状態 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 35, byteLength = 1)
    private java.lang.Integer weatherStateNow;

    /** 馬場状態・芝 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 36, byteLength = 1)
    private java.lang.Integer turfStateNow;

    /** 馬場状態・ダート */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 37, byteLength = 1)
    private java.lang.Integer dirtStateNow;

    /** 天候状態 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 38, byteLength = 1)
    private java.lang.Integer weatherStateBefere;

    /** 馬場状態・芝 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 39, byteLength = 1)
    private java.lang.Integer turfStateBefore;

    /** 馬場状態・ダート */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 40, byteLength = 1)
    private java.lang.Integer dirtStateBefore;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 開催年
     */
    public java.lang.Integer getHoldingYear() {
        return holdingYear;
    }
    
    /**
     * @param holdingYear 開催年
     */
    public void setHoldingYear(java.lang.Integer holdingYear) {
        this.holdingYear = holdingYear;
    }    
    
    /**
     * @return 開催月日
     */
    public java.lang.String getHoldingDate() {
        return holdingDate;
    }
    
    /**
     * @param holdingDate 開催月日
     */
    public void setHoldingDate(java.lang.String holdingDate) {
        this.holdingDate = holdingDate;
    }    
    
    /**
     * @return 競馬場コード
     */
    public org.stormcat.jvbeans.config.code.CourseCd getCourseCd() {
        return courseCd;
    }
    
    /**
     * @param courseCd 競馬場コード
     */
    public void setCourseCd(org.stormcat.jvbeans.config.code.CourseCd courseCd) {
        this.courseCd = courseCd;
    }    
    
    /**
     * @return 開催回[第N回]
     */
    public java.lang.Integer getHoldingNo() {
        return holdingNo;
    }
    
    /**
     * @param holdingNo 開催回[第N回]
     */
    public void setHoldingNo(java.lang.Integer holdingNo) {
        this.holdingNo = holdingNo;
    }    
    
    /**
     * @return 開催日目[N日目]
     */
    public java.lang.Integer getHoldingDay() {
        return holdingDay;
    }
    
    /**
     * @param holdingDay 開催日目[N日目]
     */
    public void setHoldingDay(java.lang.Integer holdingDay) {
        this.holdingDay = holdingDay;
    }    
    
    /**
     * @return 発表月日時分
     */
    public java.util.Date getAnnounceDate() {
        return announceDate;
    }
    
    /**
     * @param announceDate 発表月日時分
     */
    public void setAnnounceDate(java.util.Date announceDate) {
        this.announceDate = announceDate;
    }    
    
    /**
     * @return 変更識別
     */
    public java.lang.Integer getChangeIdentification() {
        return changeIdentification;
    }
    
    /**
     * @param changeIdentification 変更識別
     */
    public void setChangeIdentification(java.lang.Integer changeIdentification) {
        this.changeIdentification = changeIdentification;
    }    
    
    /**
     * @return 天候状態
     */
    public java.lang.Integer getWeatherStateNow() {
        return weatherStateNow;
    }
    
    /**
     * @param weatherStateNow 天候状態
     */
    public void setWeatherStateNow(java.lang.Integer weatherStateNow) {
        this.weatherStateNow = weatherStateNow;
    }    
    
    /**
     * @return 馬場状態・芝
     */
    public java.lang.Integer getTurfStateNow() {
        return turfStateNow;
    }
    
    /**
     * @param turfStateNow 馬場状態・芝
     */
    public void setTurfStateNow(java.lang.Integer turfStateNow) {
        this.turfStateNow = turfStateNow;
    }    
    
    /**
     * @return 馬場状態・ダート
     */
    public java.lang.Integer getDirtStateNow() {
        return dirtStateNow;
    }
    
    /**
     * @param dirtStateNow 馬場状態・ダート
     */
    public void setDirtStateNow(java.lang.Integer dirtStateNow) {
        this.dirtStateNow = dirtStateNow;
    }    
    
    /**
     * @return 天候状態
     */
    public java.lang.Integer getWeatherStateBefere() {
        return weatherStateBefere;
    }
    
    /**
     * @param weatherStateBefere 天候状態
     */
    public void setWeatherStateBefere(java.lang.Integer weatherStateBefere) {
        this.weatherStateBefere = weatherStateBefere;
    }    
    
    /**
     * @return 馬場状態・芝
     */
    public java.lang.Integer getTurfStateBefore() {
        return turfStateBefore;
    }
    
    /**
     * @param turfStateBefore 馬場状態・芝
     */
    public void setTurfStateBefore(java.lang.Integer turfStateBefore) {
        this.turfStateBefore = turfStateBefore;
    }    
    
    /**
     * @return 馬場状態・ダート
     */
    public java.lang.Integer getDirtStateBefore() {
        return dirtStateBefore;
    }
    
    /**
     * @param dirtStateBefore 馬場状態・ダート
     */
    public void setDirtStateBefore(java.lang.Integer dirtStateBefore) {
        this.dirtStateBefore = dirtStateBefore;
    }    
    
}