/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.TK} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.TK, byteLength = 21657)
public class TokubetsuTourokubaDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 開催年 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 4)
    private java.lang.Integer holdingYear;

    /** 開催月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 16, byteLength = 4)
    private java.lang.String holdingDate;

    /** 競馬場コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 20, byteLength = 2)
    private org.stormcat.jvbeans.config.code.CourseCd courseCd;

    /** 開催回[第N回] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 22, byteLength = 2)
    private java.lang.Integer holdingNo;

    /** 開催日目[N日目] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 24, byteLength = 2)
    private java.lang.Integer holdingDay;

    /** レース番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 26, byteLength = 2)
    private java.lang.Integer raceNo;

    /** 曜日コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28, byteLength = 1)
    private org.stormcat.jvbeans.config.code.WeekDayCd weekDayCd;

    /** 特別競走番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 29, byteLength = 4)
    private java.lang.Integer specialRaceNo;

    /** 競走名本題 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 33, byteLength = 60)
    private java.lang.String raceNameFull;

    /** 競走名副題 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 93, byteLength = 60)
    private java.lang.String raceNameSub;

    /** 競走名カッコ内 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 153, byteLength = 60)
    private java.lang.String raceNameNote;

    /** 競走名本題欧字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 213, byteLength = 120)
    private java.lang.String raceNameFullEng;

    /** 競走名副題欧字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 333, byteLength = 120)
    private java.lang.String raceNameSubEng;

    /** 競走名カッコ内欧字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 453, byteLength = 120)
    private java.lang.String raceNameNoteEng;

    /** 競走名略称１0文字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 573, byteLength = 20)
    private java.lang.String raceNameShortChar10;

    /** 競走名略称6文字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 593, byteLength = 12)
    private java.lang.String raceNameShortChar6;

    /** 競走名略称3文字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 605, byteLength = 6)
    private java.lang.String raceNameShortChar3;

    /** 競走名区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 611, byteLength = 1)
    private java.lang.Integer raceNameDiv;

    /** 重賞回次[第N回] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 612, byteLength = 3)
    private java.lang.Integer gradeTimes;

    /** グレードコード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 615, byteLength = 1)
    private org.stormcat.jvbeans.config.code.GradeCd gradeCd;

    /** 競走種別コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 616, byteLength = 2)
    private org.stormcat.jvbeans.config.code.RaceTypeCd raceTypeCd;

    /** 競走記号コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 618, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceSignCd raceSignCd;

    /** 重量種別コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 621, byteLength = 1)
    private org.stormcat.jvbeans.config.code.WeightTypeCd weightTypeCd;

    /** 競走条件コード 2歳条件 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 622, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld2;

    /** 競走条件コード 3歳条件 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 625, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld3;

    /** 競走条件コード 4歳条件 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 628, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld4;

    /** 競走条件コード 5歳以上条件 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 631, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld5;

    /** 競走条件コード 最若年条件 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 634, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdYoungest;

    /** 距離 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 637, byteLength = 4)
    private java.lang.Integer distance;

    /** トラックコード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 641, byteLength = 2)
    private org.stormcat.jvbeans.config.code.TrackCd trackCd;

    /** コース区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 643, byteLength = 2)
    private java.lang.String courseDiv;

    /** ハンデ発表日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 645, byteLength = 8)
    private java.lang.String handicapAnnounceDate;

    /** 登録頭数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 653, byteLength = 3)
    private java.lang.String entryCount;

    /** 登録馬毎情報 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 656, byteLength = 70, repeatCount = 300)
    private java.util.List<org.stormcat.jvbeans.dto.child.EntryHorseInfo> entryHorseInfoItems;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 開催年
     */
    public java.lang.Integer getHoldingYear() {
        return holdingYear;
    }
    
    /**
     * @param holdingYear 開催年
     */
    public void setHoldingYear(java.lang.Integer holdingYear) {
        this.holdingYear = holdingYear;
    }    
    
    /**
     * @return 開催月日
     */
    public java.lang.String getHoldingDate() {
        return holdingDate;
    }
    
    /**
     * @param holdingDate 開催月日
     */
    public void setHoldingDate(java.lang.String holdingDate) {
        this.holdingDate = holdingDate;
    }    
    
    /**
     * @return 競馬場コード
     */
    public org.stormcat.jvbeans.config.code.CourseCd getCourseCd() {
        return courseCd;
    }
    
    /**
     * @param courseCd 競馬場コード
     */
    public void setCourseCd(org.stormcat.jvbeans.config.code.CourseCd courseCd) {
        this.courseCd = courseCd;
    }    
    
    /**
     * @return 開催回[第N回]
     */
    public java.lang.Integer getHoldingNo() {
        return holdingNo;
    }
    
    /**
     * @param holdingNo 開催回[第N回]
     */
    public void setHoldingNo(java.lang.Integer holdingNo) {
        this.holdingNo = holdingNo;
    }    
    
    /**
     * @return 開催日目[N日目]
     */
    public java.lang.Integer getHoldingDay() {
        return holdingDay;
    }
    
    /**
     * @param holdingDay 開催日目[N日目]
     */
    public void setHoldingDay(java.lang.Integer holdingDay) {
        this.holdingDay = holdingDay;
    }    
    
    /**
     * @return レース番号
     */
    public java.lang.Integer getRaceNo() {
        return raceNo;
    }
    
    /**
     * @param raceNo レース番号
     */
    public void setRaceNo(java.lang.Integer raceNo) {
        this.raceNo = raceNo;
    }    
    
    /**
     * @return 曜日コード
     */
    public org.stormcat.jvbeans.config.code.WeekDayCd getWeekDayCd() {
        return weekDayCd;
    }
    
    /**
     * @param weekDayCd 曜日コード
     */
    public void setWeekDayCd(org.stormcat.jvbeans.config.code.WeekDayCd weekDayCd) {
        this.weekDayCd = weekDayCd;
    }    
    
    /**
     * @return 特別競走番号
     */
    public java.lang.Integer getSpecialRaceNo() {
        return specialRaceNo;
    }
    
    /**
     * @param specialRaceNo 特別競走番号
     */
    public void setSpecialRaceNo(java.lang.Integer specialRaceNo) {
        this.specialRaceNo = specialRaceNo;
    }    
    
    /**
     * @return 競走名本題
     */
    public java.lang.String getRaceNameFull() {
        return raceNameFull;
    }
    
    /**
     * @param raceNameFull 競走名本題
     */
    public void setRaceNameFull(java.lang.String raceNameFull) {
        this.raceNameFull = raceNameFull;
    }    
    
    /**
     * @return 競走名副題
     */
    public java.lang.String getRaceNameSub() {
        return raceNameSub;
    }
    
    /**
     * @param raceNameSub 競走名副題
     */
    public void setRaceNameSub(java.lang.String raceNameSub) {
        this.raceNameSub = raceNameSub;
    }    
    
    /**
     * @return 競走名カッコ内
     */
    public java.lang.String getRaceNameNote() {
        return raceNameNote;
    }
    
    /**
     * @param raceNameNote 競走名カッコ内
     */
    public void setRaceNameNote(java.lang.String raceNameNote) {
        this.raceNameNote = raceNameNote;
    }    
    
    /**
     * @return 競走名本題欧字
     */
    public java.lang.String getRaceNameFullEng() {
        return raceNameFullEng;
    }
    
    /**
     * @param raceNameFullEng 競走名本題欧字
     */
    public void setRaceNameFullEng(java.lang.String raceNameFullEng) {
        this.raceNameFullEng = raceNameFullEng;
    }    
    
    /**
     * @return 競走名副題欧字
     */
    public java.lang.String getRaceNameSubEng() {
        return raceNameSubEng;
    }
    
    /**
     * @param raceNameSubEng 競走名副題欧字
     */
    public void setRaceNameSubEng(java.lang.String raceNameSubEng) {
        this.raceNameSubEng = raceNameSubEng;
    }    
    
    /**
     * @return 競走名カッコ内欧字
     */
    public java.lang.String getRaceNameNoteEng() {
        return raceNameNoteEng;
    }
    
    /**
     * @param raceNameNoteEng 競走名カッコ内欧字
     */
    public void setRaceNameNoteEng(java.lang.String raceNameNoteEng) {
        this.raceNameNoteEng = raceNameNoteEng;
    }    
    
    /**
     * @return 競走名略称１0文字
     */
    public java.lang.String getRaceNameShortChar10() {
        return raceNameShortChar10;
    }
    
    /**
     * @param raceNameShortChar10 競走名略称１0文字
     */
    public void setRaceNameShortChar10(java.lang.String raceNameShortChar10) {
        this.raceNameShortChar10 = raceNameShortChar10;
    }    
    
    /**
     * @return 競走名略称6文字
     */
    public java.lang.String getRaceNameShortChar6() {
        return raceNameShortChar6;
    }
    
    /**
     * @param raceNameShortChar6 競走名略称6文字
     */
    public void setRaceNameShortChar6(java.lang.String raceNameShortChar6) {
        this.raceNameShortChar6 = raceNameShortChar6;
    }    
    
    /**
     * @return 競走名略称3文字
     */
    public java.lang.String getRaceNameShortChar3() {
        return raceNameShortChar3;
    }
    
    /**
     * @param raceNameShortChar3 競走名略称3文字
     */
    public void setRaceNameShortChar3(java.lang.String raceNameShortChar3) {
        this.raceNameShortChar3 = raceNameShortChar3;
    }    
    
    /**
     * @return 競走名区分
     */
    public java.lang.Integer getRaceNameDiv() {
        return raceNameDiv;
    }
    
    /**
     * @param raceNameDiv 競走名区分
     */
    public void setRaceNameDiv(java.lang.Integer raceNameDiv) {
        this.raceNameDiv = raceNameDiv;
    }    
    
    /**
     * @return 重賞回次[第N回]
     */
    public java.lang.Integer getGradeTimes() {
        return gradeTimes;
    }
    
    /**
     * @param gradeTimes 重賞回次[第N回]
     */
    public void setGradeTimes(java.lang.Integer gradeTimes) {
        this.gradeTimes = gradeTimes;
    }    
    
    /**
     * @return グレードコード
     */
    public org.stormcat.jvbeans.config.code.GradeCd getGradeCd() {
        return gradeCd;
    }
    
    /**
     * @param gradeCd グレードコード
     */
    public void setGradeCd(org.stormcat.jvbeans.config.code.GradeCd gradeCd) {
        this.gradeCd = gradeCd;
    }    
    
    /**
     * @return 競走種別コード
     */
    public org.stormcat.jvbeans.config.code.RaceTypeCd getRaceTypeCd() {
        return raceTypeCd;
    }
    
    /**
     * @param raceTypeCd 競走種別コード
     */
    public void setRaceTypeCd(org.stormcat.jvbeans.config.code.RaceTypeCd raceTypeCd) {
        this.raceTypeCd = raceTypeCd;
    }    
    
    /**
     * @return 競走記号コード
     */
    public org.stormcat.jvbeans.config.code.RaceSignCd getRaceSignCd() {
        return raceSignCd;
    }
    
    /**
     * @param raceSignCd 競走記号コード
     */
    public void setRaceSignCd(org.stormcat.jvbeans.config.code.RaceSignCd raceSignCd) {
        this.raceSignCd = raceSignCd;
    }    
    
    /**
     * @return 重量種別コード
     */
    public org.stormcat.jvbeans.config.code.WeightTypeCd getWeightTypeCd() {
        return weightTypeCd;
    }
    
    /**
     * @param weightTypeCd 重量種別コード
     */
    public void setWeightTypeCd(org.stormcat.jvbeans.config.code.WeightTypeCd weightTypeCd) {
        this.weightTypeCd = weightTypeCd;
    }    
    
    /**
     * @return 競走条件コード 2歳条件
     */
    public org.stormcat.jvbeans.config.code.RaceConditionCd getRaceConditionCdOld2() {
        return raceConditionCdOld2;
    }
    
    /**
     * @param raceConditionCdOld2 競走条件コード 2歳条件
     */
    public void setRaceConditionCdOld2(org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld2) {
        this.raceConditionCdOld2 = raceConditionCdOld2;
    }    
    
    /**
     * @return 競走条件コード 3歳条件
     */
    public org.stormcat.jvbeans.config.code.RaceConditionCd getRaceConditionCdOld3() {
        return raceConditionCdOld3;
    }
    
    /**
     * @param raceConditionCdOld3 競走条件コード 3歳条件
     */
    public void setRaceConditionCdOld3(org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld3) {
        this.raceConditionCdOld3 = raceConditionCdOld3;
    }    
    
    /**
     * @return 競走条件コード 4歳条件
     */
    public org.stormcat.jvbeans.config.code.RaceConditionCd getRaceConditionCdOld4() {
        return raceConditionCdOld4;
    }
    
    /**
     * @param raceConditionCdOld4 競走条件コード 4歳条件
     */
    public void setRaceConditionCdOld4(org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld4) {
        this.raceConditionCdOld4 = raceConditionCdOld4;
    }    
    
    /**
     * @return 競走条件コード 5歳以上条件
     */
    public org.stormcat.jvbeans.config.code.RaceConditionCd getRaceConditionCdOld5() {
        return raceConditionCdOld5;
    }
    
    /**
     * @param raceConditionCdOld5 競走条件コード 5歳以上条件
     */
    public void setRaceConditionCdOld5(org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld5) {
        this.raceConditionCdOld5 = raceConditionCdOld5;
    }    
    
    /**
     * @return 競走条件コード 最若年条件
     */
    public org.stormcat.jvbeans.config.code.RaceConditionCd getRaceConditionCdYoungest() {
        return raceConditionCdYoungest;
    }
    
    /**
     * @param raceConditionCdYoungest 競走条件コード 最若年条件
     */
    public void setRaceConditionCdYoungest(org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdYoungest) {
        this.raceConditionCdYoungest = raceConditionCdYoungest;
    }    
    
    /**
     * @return 距離
     */
    public java.lang.Integer getDistance() {
        return distance;
    }
    
    /**
     * @param distance 距離
     */
    public void setDistance(java.lang.Integer distance) {
        this.distance = distance;
    }    
    
    /**
     * @return トラックコード
     */
    public org.stormcat.jvbeans.config.code.TrackCd getTrackCd() {
        return trackCd;
    }
    
    /**
     * @param trackCd トラックコード
     */
    public void setTrackCd(org.stormcat.jvbeans.config.code.TrackCd trackCd) {
        this.trackCd = trackCd;
    }    
    
    /**
     * @return コース区分
     */
    public java.lang.String getCourseDiv() {
        return courseDiv;
    }
    
    /**
     * @param courseDiv コース区分
     */
    public void setCourseDiv(java.lang.String courseDiv) {
        this.courseDiv = courseDiv;
    }    
    
    /**
     * @return ハンデ発表日
     */
    public java.lang.String getHandicapAnnounceDate() {
        return handicapAnnounceDate;
    }
    
    /**
     * @param handicapAnnounceDate ハンデ発表日
     */
    public void setHandicapAnnounceDate(java.lang.String handicapAnnounceDate) {
        this.handicapAnnounceDate = handicapAnnounceDate;
    }    
    
    /**
     * @return 登録頭数
     */
    public java.lang.String getEntryCount() {
        return entryCount;
    }
    
    /**
     * @param entryCount 登録頭数
     */
    public void setEntryCount(java.lang.String entryCount) {
        this.entryCount = entryCount;
    }    
    
    /**
     * @return 登録馬毎情報
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.EntryHorseInfo> getEntryHorseInfoItems() {
        return entryHorseInfoItems;
    }
    
    /**
     * @param entryHorseInfoItems 登録馬毎情報
     */
    public void setEntryHorseInfoItems(java.util.List<org.stormcat.jvbeans.dto.child.EntryHorseInfo> entryHorseInfoItems) {
        this.entryHorseInfoItems = entryHorseInfoItems;
    }      
    
}