/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.RA} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.RA, byteLength = 1272)
public class RaceDetailDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 開催年 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 4)
    private java.lang.Integer holdingYear;

    /** 開催月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 16, byteLength = 4)
    private java.lang.String holdingDate;

    /** 競馬場コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 20, byteLength = 2)
    private org.stormcat.jvbeans.config.code.CourseCd courseCd;

    /** 開催回[第N回] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 22, byteLength = 2)
    private java.lang.Integer holdingNo;

    /** 開催日目[N日目] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 24, byteLength = 2)
    private java.lang.Integer holdingDay;

    /** レース番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 26, byteLength = 2)
    private java.lang.Integer raceNo;

    /** 曜日コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28, byteLength = 1)
    private org.stormcat.jvbeans.config.code.WeekDayCd weekDayCd;

    /** 特別競走番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 29, byteLength = 4)
    private java.lang.Integer specialRaceNo;

    /** 競走名本題 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 33, byteLength = 60)
    private java.lang.String raceNameFull;

    /** 競走名副題 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 93, byteLength = 60)
    private java.lang.String raceNameSub;

    /** 競走名カッコ内 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 153, byteLength = 60)
    private java.lang.String raceNameNote;

    /** 競走名本題欧字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 213, byteLength = 120)
    private java.lang.String raceNameFullEng;

    /** 競走名副題欧字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 333, byteLength = 120)
    private java.lang.String raceNameSubEng;

    /** 競走名カッコ内欧字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 453, byteLength = 120)
    private java.lang.String raceNameNoteEng;

    /** 競走名略称１0文字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 573, byteLength = 20)
    private java.lang.String raceNameShortChar10;

    /** 競走名略称6文字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 593, byteLength = 12)
    private java.lang.String raceNameShortChar6;

    /** 競走名略称3文字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 605, byteLength = 6)
    private java.lang.String raceNameShortChar3;

    /** 競走名区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 611, byteLength = 1)
    private java.lang.Integer raceNameDiv;

    /** 重賞回次[第N回] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 612, byteLength = 3)
    private java.lang.Integer gradeTimes;

    /** グレードコード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 615, byteLength = 1)
    private org.stormcat.jvbeans.config.code.GradeCd gradeCd;

    /** 変更前グレードコード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 616, byteLength = 1)
    private org.stormcat.jvbeans.config.code.GradeCd gradeCdBefore;

    /** 競走種別コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 617, byteLength = 2)
    private org.stormcat.jvbeans.config.code.RaceTypeCd raceTypeCd;

    /** 競走記号コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 619, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceSignCd raceSignCd;

    /** 重量種別コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 622, byteLength = 1)
    private org.stormcat.jvbeans.config.code.WeightTypeCd weightTypeCd;

    /** 競走条件コード 2歳条件 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 623, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld2;

    /** 競走条件コード 3歳条件 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 626, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld3;

    /** 競走条件コード 4歳条件 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 629, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld4;

    /** 競走条件コード 5歳以上条件 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 632, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld5;

    /** 競走条件コード 最若年条件 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 635, byteLength = 3)
    private org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdYoungest;

    /** 競走条件名称 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 638, byteLength = 60)
    private java.lang.String raceConditionName;

    /** 距離 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 698, byteLength = 4)
    private java.lang.String distance;

    /** 変更前距離 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 702, byteLength = 4)
    private java.lang.String distanceBefore;

    /** トラックコード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 706, byteLength = 2)
    private org.stormcat.jvbeans.config.code.TrackCd trackCd;

    /** 変更前トラックコード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 708, byteLength = 2)
    private org.stormcat.jvbeans.config.code.TrackCd trackCdBefore;

    /** コース区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 710, byteLength = 2)
    private java.lang.String courseDiv;

    /** 変更前コース区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 712, byteLength = 2)
    private java.lang.String courseDivBefore;

    /** 本賞金 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 714, byteLength = 8, repeatCount = 7)
    private java.util.List<java.lang.Long> addedMoneyItems;

    /** 変更前本賞金 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 770, byteLength = 8, repeatCount = 5)
    private java.util.List<java.lang.Long> addedMoneyBeforeItems;

    /** 付加賞金 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 810, byteLength = 8, repeatCount = 5)
    private java.util.List<java.lang.Long> stakesMoneyItems;

    /** 変更前付加賞金 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 850, byteLength = 8, repeatCount = 3)
    private java.util.List<java.lang.Long> stakesMoneyBeforeItems;

    /** 発走時刻 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 874, byteLength = 4)
    private java.lang.String startTime;

    /** 変更前発走時刻 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 878, byteLength = 4)
    private java.lang.String startTimeBefore;

    /** 登録頭数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 882, byteLength = 2)
    private java.lang.String entryCount;

    /** 出走頭数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 884, byteLength = 2)
    private java.lang.String starterCount;

    /** 入線頭数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 886, byteLength = 2)
    private java.lang.String finishedCount;

    /** 天候コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 888, byteLength = 1)
    private org.stormcat.jvbeans.config.code.WeatherCd weatherCd;

    /** 芝馬場状態コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 889, byteLength = 1)
    private org.stormcat.jvbeans.config.code.CourseConditionCd turfConditionCd;

    /** ダート馬場状態コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 890, byteLength = 1)
    private org.stormcat.jvbeans.config.code.CourseConditionCd dirtConditionCd;

    /** ラップタイム */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 891, byteLength = 3, repeatCount = 25)
    private java.util.List<java.lang.Float> lapTimeItems;

    /** 障害マイルタイム */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 966, byteLength = 4)
    private java.lang.String obstacleMileTime;

    /** 前３ハロン */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 970, byteLength = 3)
    private java.lang.Float firstFurlong3;

    /** 前４ハロン */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 973, byteLength = 3)
    private java.lang.Float firstFurlong4;

    /** 後３ハロン */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 976, byteLength = 3)
    private java.lang.Float lastFurlong3;

    /** 後４ハロン */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 979, byteLength = 3)
    private java.lang.Float lastFurlong4;

    /** コーナー通過順位 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 982, byteLength = 72, repeatCount = 4)
    private java.util.List<org.stormcat.jvbeans.dto.child.CornerPassageRankDto> cornerPassageRankItems;

    /** レコード更新区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1270, byteLength = 1)
    private java.lang.String recordBreakDiv;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 開催年
     */
    public java.lang.Integer getHoldingYear() {
        return holdingYear;
    }
    
    /**
     * @param holdingYear 開催年
     */
    public void setHoldingYear(java.lang.Integer holdingYear) {
        this.holdingYear = holdingYear;
    }    
    
    /**
     * @return 開催月日
     */
    public java.lang.String getHoldingDate() {
        return holdingDate;
    }
    
    /**
     * @param holdingDate 開催月日
     */
    public void setHoldingDate(java.lang.String holdingDate) {
        this.holdingDate = holdingDate;
    }    
    
    /**
     * @return 競馬場コード
     */
    public org.stormcat.jvbeans.config.code.CourseCd getCourseCd() {
        return courseCd;
    }
    
    /**
     * @param courseCd 競馬場コード
     */
    public void setCourseCd(org.stormcat.jvbeans.config.code.CourseCd courseCd) {
        this.courseCd = courseCd;
    }    
    
    /**
     * @return 開催回[第N回]
     */
    public java.lang.Integer getHoldingNo() {
        return holdingNo;
    }
    
    /**
     * @param holdingNo 開催回[第N回]
     */
    public void setHoldingNo(java.lang.Integer holdingNo) {
        this.holdingNo = holdingNo;
    }    
    
    /**
     * @return 開催日目[N日目]
     */
    public java.lang.Integer getHoldingDay() {
        return holdingDay;
    }
    
    /**
     * @param holdingDay 開催日目[N日目]
     */
    public void setHoldingDay(java.lang.Integer holdingDay) {
        this.holdingDay = holdingDay;
    }    
    
    /**
     * @return レース番号
     */
    public java.lang.Integer getRaceNo() {
        return raceNo;
    }
    
    /**
     * @param raceNo レース番号
     */
    public void setRaceNo(java.lang.Integer raceNo) {
        this.raceNo = raceNo;
    }    
    
    /**
     * @return 曜日コード
     */
    public org.stormcat.jvbeans.config.code.WeekDayCd getWeekDayCd() {
        return weekDayCd;
    }
    
    /**
     * @param weekDayCd 曜日コード
     */
    public void setWeekDayCd(org.stormcat.jvbeans.config.code.WeekDayCd weekDayCd) {
        this.weekDayCd = weekDayCd;
    }    
    
    /**
     * @return 特別競走番号
     */
    public java.lang.Integer getSpecialRaceNo() {
        return specialRaceNo;
    }
    
    /**
     * @param specialRaceNo 特別競走番号
     */
    public void setSpecialRaceNo(java.lang.Integer specialRaceNo) {
        this.specialRaceNo = specialRaceNo;
    }    
    
    /**
     * @return 競走名本題
     */
    public java.lang.String getRaceNameFull() {
        return raceNameFull;
    }
    
    /**
     * @param raceNameFull 競走名本題
     */
    public void setRaceNameFull(java.lang.String raceNameFull) {
        this.raceNameFull = raceNameFull;
    }    
    
    /**
     * @return 競走名副題
     */
    public java.lang.String getRaceNameSub() {
        return raceNameSub;
    }
    
    /**
     * @param raceNameSub 競走名副題
     */
    public void setRaceNameSub(java.lang.String raceNameSub) {
        this.raceNameSub = raceNameSub;
    }    
    
    /**
     * @return 競走名カッコ内
     */
    public java.lang.String getRaceNameNote() {
        return raceNameNote;
    }
    
    /**
     * @param raceNameNote 競走名カッコ内
     */
    public void setRaceNameNote(java.lang.String raceNameNote) {
        this.raceNameNote = raceNameNote;
    }    
    
    /**
     * @return 競走名本題欧字
     */
    public java.lang.String getRaceNameFullEng() {
        return raceNameFullEng;
    }
    
    /**
     * @param raceNameFullEng 競走名本題欧字
     */
    public void setRaceNameFullEng(java.lang.String raceNameFullEng) {
        this.raceNameFullEng = raceNameFullEng;
    }    
    
    /**
     * @return 競走名副題欧字
     */
    public java.lang.String getRaceNameSubEng() {
        return raceNameSubEng;
    }
    
    /**
     * @param raceNameSubEng 競走名副題欧字
     */
    public void setRaceNameSubEng(java.lang.String raceNameSubEng) {
        this.raceNameSubEng = raceNameSubEng;
    }    
    
    /**
     * @return 競走名カッコ内欧字
     */
    public java.lang.String getRaceNameNoteEng() {
        return raceNameNoteEng;
    }
    
    /**
     * @param raceNameNoteEng 競走名カッコ内欧字
     */
    public void setRaceNameNoteEng(java.lang.String raceNameNoteEng) {
        this.raceNameNoteEng = raceNameNoteEng;
    }    
    
    /**
     * @return 競走名略称１0文字
     */
    public java.lang.String getRaceNameShortChar10() {
        return raceNameShortChar10;
    }
    
    /**
     * @param raceNameShortChar10 競走名略称１0文字
     */
    public void setRaceNameShortChar10(java.lang.String raceNameShortChar10) {
        this.raceNameShortChar10 = raceNameShortChar10;
    }    
    
    /**
     * @return 競走名略称6文字
     */
    public java.lang.String getRaceNameShortChar6() {
        return raceNameShortChar6;
    }
    
    /**
     * @param raceNameShortChar6 競走名略称6文字
     */
    public void setRaceNameShortChar6(java.lang.String raceNameShortChar6) {
        this.raceNameShortChar6 = raceNameShortChar6;
    }    
    
    /**
     * @return 競走名略称3文字
     */
    public java.lang.String getRaceNameShortChar3() {
        return raceNameShortChar3;
    }
    
    /**
     * @param raceNameShortChar3 競走名略称3文字
     */
    public void setRaceNameShortChar3(java.lang.String raceNameShortChar3) {
        this.raceNameShortChar3 = raceNameShortChar3;
    }    
    
    /**
     * @return 競走名区分
     */
    public java.lang.Integer getRaceNameDiv() {
        return raceNameDiv;
    }
    
    /**
     * @param raceNameDiv 競走名区分
     */
    public void setRaceNameDiv(java.lang.Integer raceNameDiv) {
        this.raceNameDiv = raceNameDiv;
    }    
    
    /**
     * @return 重賞回次[第N回]
     */
    public java.lang.Integer getGradeTimes() {
        return gradeTimes;
    }
    
    /**
     * @param gradeTimes 重賞回次[第N回]
     */
    public void setGradeTimes(java.lang.Integer gradeTimes) {
        this.gradeTimes = gradeTimes;
    }    
    
    /**
     * @return グレードコード
     */
    public org.stormcat.jvbeans.config.code.GradeCd getGradeCd() {
        return gradeCd;
    }
    
    /**
     * @param gradeCd グレードコード
     */
    public void setGradeCd(org.stormcat.jvbeans.config.code.GradeCd gradeCd) {
        this.gradeCd = gradeCd;
    }    
    
    /**
     * @return 変更前グレードコード
     */
    public org.stormcat.jvbeans.config.code.GradeCd getGradeCdBefore() {
        return gradeCdBefore;
    }
    
    /**
     * @param gradeCdBefore 変更前グレードコード
     */
    public void setGradeCdBefore(org.stormcat.jvbeans.config.code.GradeCd gradeCdBefore) {
        this.gradeCdBefore = gradeCdBefore;
    }    
    
    /**
     * @return 競走種別コード
     */
    public org.stormcat.jvbeans.config.code.RaceTypeCd getRaceTypeCd() {
        return raceTypeCd;
    }
    
    /**
     * @param raceTypeCd 競走種別コード
     */
    public void setRaceTypeCd(org.stormcat.jvbeans.config.code.RaceTypeCd raceTypeCd) {
        this.raceTypeCd = raceTypeCd;
    }    
    
    /**
     * @return 競走記号コード
     */
    public org.stormcat.jvbeans.config.code.RaceSignCd getRaceSignCd() {
        return raceSignCd;
    }
    
    /**
     * @param raceSignCd 競走記号コード
     */
    public void setRaceSignCd(org.stormcat.jvbeans.config.code.RaceSignCd raceSignCd) {
        this.raceSignCd = raceSignCd;
    }    
    
    /**
     * @return 重量種別コード
     */
    public org.stormcat.jvbeans.config.code.WeightTypeCd getWeightTypeCd() {
        return weightTypeCd;
    }
    
    /**
     * @param weightTypeCd 重量種別コード
     */
    public void setWeightTypeCd(org.stormcat.jvbeans.config.code.WeightTypeCd weightTypeCd) {
        this.weightTypeCd = weightTypeCd;
    }    
    
    /**
     * @return 競走条件コード 2歳条件
     */
    public org.stormcat.jvbeans.config.code.RaceConditionCd getRaceConditionCdOld2() {
        return raceConditionCdOld2;
    }
    
    /**
     * @param raceConditionCdOld2 競走条件コード 2歳条件
     */
    public void setRaceConditionCdOld2(org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld2) {
        this.raceConditionCdOld2 = raceConditionCdOld2;
    }    
    
    /**
     * @return 競走条件コード 3歳条件
     */
    public org.stormcat.jvbeans.config.code.RaceConditionCd getRaceConditionCdOld3() {
        return raceConditionCdOld3;
    }
    
    /**
     * @param raceConditionCdOld3 競走条件コード 3歳条件
     */
    public void setRaceConditionCdOld3(org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld3) {
        this.raceConditionCdOld3 = raceConditionCdOld3;
    }    
    
    /**
     * @return 競走条件コード 4歳条件
     */
    public org.stormcat.jvbeans.config.code.RaceConditionCd getRaceConditionCdOld4() {
        return raceConditionCdOld4;
    }
    
    /**
     * @param raceConditionCdOld4 競走条件コード 4歳条件
     */
    public void setRaceConditionCdOld4(org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld4) {
        this.raceConditionCdOld4 = raceConditionCdOld4;
    }    
    
    /**
     * @return 競走条件コード 5歳以上条件
     */
    public org.stormcat.jvbeans.config.code.RaceConditionCd getRaceConditionCdOld5() {
        return raceConditionCdOld5;
    }
    
    /**
     * @param raceConditionCdOld5 競走条件コード 5歳以上条件
     */
    public void setRaceConditionCdOld5(org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdOld5) {
        this.raceConditionCdOld5 = raceConditionCdOld5;
    }    
    
    /**
     * @return 競走条件コード 最若年条件
     */
    public org.stormcat.jvbeans.config.code.RaceConditionCd getRaceConditionCdYoungest() {
        return raceConditionCdYoungest;
    }
    
    /**
     * @param raceConditionCdYoungest 競走条件コード 最若年条件
     */
    public void setRaceConditionCdYoungest(org.stormcat.jvbeans.config.code.RaceConditionCd raceConditionCdYoungest) {
        this.raceConditionCdYoungest = raceConditionCdYoungest;
    }    
    
    /**
     * @return 競走条件名称
     */
    public java.lang.String getRaceConditionName() {
        return raceConditionName;
    }
    
    /**
     * @param raceConditionName 競走条件名称
     */
    public void setRaceConditionName(java.lang.String raceConditionName) {
        this.raceConditionName = raceConditionName;
    }    
    
    /**
     * @return 距離
     */
    public java.lang.String getDistance() {
        return distance;
    }
    
    /**
     * @param distance 距離
     */
    public void setDistance(java.lang.String distance) {
        this.distance = distance;
    }    
    
    /**
     * @return 変更前距離
     */
    public java.lang.String getDistanceBefore() {
        return distanceBefore;
    }
    
    /**
     * @param distanceBefore 変更前距離
     */
    public void setDistanceBefore(java.lang.String distanceBefore) {
        this.distanceBefore = distanceBefore;
    }    
    
    /**
     * @return トラックコード
     */
    public org.stormcat.jvbeans.config.code.TrackCd getTrackCd() {
        return trackCd;
    }
    
    /**
     * @param trackCd トラックコード
     */
    public void setTrackCd(org.stormcat.jvbeans.config.code.TrackCd trackCd) {
        this.trackCd = trackCd;
    }    
    
    /**
     * @return 変更前トラックコード
     */
    public org.stormcat.jvbeans.config.code.TrackCd getTrackCdBefore() {
        return trackCdBefore;
    }
    
    /**
     * @param trackCdBefore 変更前トラックコード
     */
    public void setTrackCdBefore(org.stormcat.jvbeans.config.code.TrackCd trackCdBefore) {
        this.trackCdBefore = trackCdBefore;
    }    
    
    /**
     * @return コース区分
     */
    public java.lang.String getCourseDiv() {
        return courseDiv;
    }
    
    /**
     * @param courseDiv コース区分
     */
    public void setCourseDiv(java.lang.String courseDiv) {
        this.courseDiv = courseDiv;
    }    
    
    /**
     * @return 変更前コース区分
     */
    public java.lang.String getCourseDivBefore() {
        return courseDivBefore;
    }
    
    /**
     * @param courseDivBefore 変更前コース区分
     */
    public void setCourseDivBefore(java.lang.String courseDivBefore) {
        this.courseDivBefore = courseDivBefore;
    }    
    
    /**
     * @return 本賞金
     */
    public java.util.List<java.lang.Long> getAddedMoneyItems() {
        return addedMoneyItems;
    }
    
    /**
     * @param addedMoneyItems 本賞金
     */
    public void setAddedMoneyItems(java.util.List<java.lang.Long> addedMoneyItems) {
        this.addedMoneyItems = addedMoneyItems;
    }      
    
    /**
     * @return 変更前本賞金
     */
    public java.util.List<java.lang.Long> getAddedMoneyBeforeItems() {
        return addedMoneyBeforeItems;
    }
    
    /**
     * @param addedMoneyBeforeItems 変更前本賞金
     */
    public void setAddedMoneyBeforeItems(java.util.List<java.lang.Long> addedMoneyBeforeItems) {
        this.addedMoneyBeforeItems = addedMoneyBeforeItems;
    }      
    
    /**
     * @return 付加賞金
     */
    public java.util.List<java.lang.Long> getStakesMoneyItems() {
        return stakesMoneyItems;
    }
    
    /**
     * @param stakesMoneyItems 付加賞金
     */
    public void setStakesMoneyItems(java.util.List<java.lang.Long> stakesMoneyItems) {
        this.stakesMoneyItems = stakesMoneyItems;
    }      
    
    /**
     * @return 変更前付加賞金
     */
    public java.util.List<java.lang.Long> getStakesMoneyBeforeItems() {
        return stakesMoneyBeforeItems;
    }
    
    /**
     * @param stakesMoneyBeforeItems 変更前付加賞金
     */
    public void setStakesMoneyBeforeItems(java.util.List<java.lang.Long> stakesMoneyBeforeItems) {
        this.stakesMoneyBeforeItems = stakesMoneyBeforeItems;
    }      
    
    /**
     * @return 発走時刻
     */
    public java.lang.String getStartTime() {
        return startTime;
    }
    
    /**
     * @param startTime 発走時刻
     */
    public void setStartTime(java.lang.String startTime) {
        this.startTime = startTime;
    }    
    
    /**
     * @return 変更前発走時刻
     */
    public java.lang.String getStartTimeBefore() {
        return startTimeBefore;
    }
    
    /**
     * @param startTimeBefore 変更前発走時刻
     */
    public void setStartTimeBefore(java.lang.String startTimeBefore) {
        this.startTimeBefore = startTimeBefore;
    }    
    
    /**
     * @return 登録頭数
     */
    public java.lang.String getEntryCount() {
        return entryCount;
    }
    
    /**
     * @param entryCount 登録頭数
     */
    public void setEntryCount(java.lang.String entryCount) {
        this.entryCount = entryCount;
    }    
    
    /**
     * @return 出走頭数
     */
    public java.lang.String getStarterCount() {
        return starterCount;
    }
    
    /**
     * @param starterCount 出走頭数
     */
    public void setStarterCount(java.lang.String starterCount) {
        this.starterCount = starterCount;
    }    
    
    /**
     * @return 入線頭数
     */
    public java.lang.String getFinishedCount() {
        return finishedCount;
    }
    
    /**
     * @param finishedCount 入線頭数
     */
    public void setFinishedCount(java.lang.String finishedCount) {
        this.finishedCount = finishedCount;
    }    
    
    /**
     * @return 天候コード
     */
    public org.stormcat.jvbeans.config.code.WeatherCd getWeatherCd() {
        return weatherCd;
    }
    
    /**
     * @param weatherCd 天候コード
     */
    public void setWeatherCd(org.stormcat.jvbeans.config.code.WeatherCd weatherCd) {
        this.weatherCd = weatherCd;
    }    
    
    /**
     * @return 芝馬場状態コード
     */
    public org.stormcat.jvbeans.config.code.CourseConditionCd getTurfConditionCd() {
        return turfConditionCd;
    }
    
    /**
     * @param turfConditionCd 芝馬場状態コード
     */
    public void setTurfConditionCd(org.stormcat.jvbeans.config.code.CourseConditionCd turfConditionCd) {
        this.turfConditionCd = turfConditionCd;
    }    
    
    /**
     * @return ダート馬場状態コード
     */
    public org.stormcat.jvbeans.config.code.CourseConditionCd getDirtConditionCd() {
        return dirtConditionCd;
    }
    
    /**
     * @param dirtConditionCd ダート馬場状態コード
     */
    public void setDirtConditionCd(org.stormcat.jvbeans.config.code.CourseConditionCd dirtConditionCd) {
        this.dirtConditionCd = dirtConditionCd;
    }    
    
    /**
     * @return ラップタイム
     */
    public java.util.List<java.lang.Float> getLapTimeItems() {
        return lapTimeItems;
    }
    
    /**
     * @param lapTimeItems ラップタイム
     */
    public void setLapTimeItems(java.util.List<java.lang.Float> lapTimeItems) {
        this.lapTimeItems = lapTimeItems;
    }      
    
    /**
     * @return 障害マイルタイム
     */
    public java.lang.String getObstacleMileTime() {
        return obstacleMileTime;
    }
    
    /**
     * @param obstacleMileTime 障害マイルタイム
     */
    public void setObstacleMileTime(java.lang.String obstacleMileTime) {
        this.obstacleMileTime = obstacleMileTime;
    }    
    
    /**
     * @return 前３ハロン
     */
    public java.lang.Float getFirstFurlong3() {
        return firstFurlong3;
    }
    
    /**
     * @param firstFurlong3 前３ハロン
     */
    public void setFirstFurlong3(java.lang.Float firstFurlong3) {
        this.firstFurlong3 = firstFurlong3;
    }    
    
    /**
     * @return 前４ハロン
     */
    public java.lang.Float getFirstFurlong4() {
        return firstFurlong4;
    }
    
    /**
     * @param firstFurlong4 前４ハロン
     */
    public void setFirstFurlong4(java.lang.Float firstFurlong4) {
        this.firstFurlong4 = firstFurlong4;
    }    
    
    /**
     * @return 後３ハロン
     */
    public java.lang.Float getLastFurlong3() {
        return lastFurlong3;
    }
    
    /**
     * @param lastFurlong3 後３ハロン
     */
    public void setLastFurlong3(java.lang.Float lastFurlong3) {
        this.lastFurlong3 = lastFurlong3;
    }    
    
    /**
     * @return 後４ハロン
     */
    public java.lang.Float getLastFurlong4() {
        return lastFurlong4;
    }
    
    /**
     * @param lastFurlong4 後４ハロン
     */
    public void setLastFurlong4(java.lang.Float lastFurlong4) {
        this.lastFurlong4 = lastFurlong4;
    }    
    
    /**
     * @return コーナー通過順位
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.CornerPassageRankDto> getCornerPassageRankItems() {
        return cornerPassageRankItems;
    }
    
    /**
     * @param cornerPassageRankItems コーナー通過順位
     */
    public void setCornerPassageRankItems(java.util.List<org.stormcat.jvbeans.dto.child.CornerPassageRankDto> cornerPassageRankItems) {
        this.cornerPassageRankItems = cornerPassageRankItems;
    }      
    
    /**
     * @return レコード更新区分
     */
    public java.lang.String getRecordBreakDiv() {
        return recordBreakDiv;
    }
    
    /**
     * @param recordBreakDiv レコード更新区分
     */
    public void setRecordBreakDiv(java.lang.String recordBreakDiv) {
        this.recordBreakDiv = recordBreakDiv;
    }    
    
}