/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.CC} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.CC, byteLength = 50)
public class CourseChangeDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 開催年 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 4)
    private java.lang.Integer holdingYear;

    /** 開催月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 16, byteLength = 4)
    private java.lang.String holdingDate;

    /** 競馬場コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 20, byteLength = 2)
    private org.stormcat.jvbeans.config.code.CourseCd courseCd;

    /** 開催回[第N回] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 22, byteLength = 2)
    private java.lang.Integer holdingNo;

    /** 開催日目[N日目] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 24, byteLength = 2)
    private java.lang.Integer holdingDay;

    /** レース番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 26, byteLength = 2)
    private java.lang.Integer raceNo;

    /** 発表月日時分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28, byteLength = 8)
    private java.util.Date announceDate;

    /** 変更後 距離 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 36, byteLength = 4)
    private java.lang.Integer distanceAfter;

    /** 変更後 トラックコード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 40, byteLength = 2)
    private org.stormcat.jvbeans.config.code.TrackCd trackCdAfter;

    /** 変更前 距離 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 42, byteLength = 4)
    private java.lang.Integer distanceBefore;

    /** 変更前 トラックコード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 46, byteLength = 2)
    private org.stormcat.jvbeans.config.code.TrackCd trackCdBefore;

    /** 事由区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 48, byteLength = 1)
    private java.lang.String reasonDiv;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 開催年
     */
    public java.lang.Integer getHoldingYear() {
        return holdingYear;
    }
    
    /**
     * @param holdingYear 開催年
     */
    public void setHoldingYear(java.lang.Integer holdingYear) {
        this.holdingYear = holdingYear;
    }    
    
    /**
     * @return 開催月日
     */
    public java.lang.String getHoldingDate() {
        return holdingDate;
    }
    
    /**
     * @param holdingDate 開催月日
     */
    public void setHoldingDate(java.lang.String holdingDate) {
        this.holdingDate = holdingDate;
    }    
    
    /**
     * @return 競馬場コード
     */
    public org.stormcat.jvbeans.config.code.CourseCd getCourseCd() {
        return courseCd;
    }
    
    /**
     * @param courseCd 競馬場コード
     */
    public void setCourseCd(org.stormcat.jvbeans.config.code.CourseCd courseCd) {
        this.courseCd = courseCd;
    }    
    
    /**
     * @return 開催回[第N回]
     */
    public java.lang.Integer getHoldingNo() {
        return holdingNo;
    }
    
    /**
     * @param holdingNo 開催回[第N回]
     */
    public void setHoldingNo(java.lang.Integer holdingNo) {
        this.holdingNo = holdingNo;
    }    
    
    /**
     * @return 開催日目[N日目]
     */
    public java.lang.Integer getHoldingDay() {
        return holdingDay;
    }
    
    /**
     * @param holdingDay 開催日目[N日目]
     */
    public void setHoldingDay(java.lang.Integer holdingDay) {
        this.holdingDay = holdingDay;
    }    
    
    /**
     * @return レース番号
     */
    public java.lang.Integer getRaceNo() {
        return raceNo;
    }
    
    /**
     * @param raceNo レース番号
     */
    public void setRaceNo(java.lang.Integer raceNo) {
        this.raceNo = raceNo;
    }    
    
    /**
     * @return 発表月日時分
     */
    public java.util.Date getAnnounceDate() {
        return announceDate;
    }
    
    /**
     * @param announceDate 発表月日時分
     */
    public void setAnnounceDate(java.util.Date announceDate) {
        this.announceDate = announceDate;
    }    
    
    /**
     * @return 変更後 距離
     */
    public java.lang.Integer getDistanceAfter() {
        return distanceAfter;
    }
    
    /**
     * @param distanceAfter 変更後 距離
     */
    public void setDistanceAfter(java.lang.Integer distanceAfter) {
        this.distanceAfter = distanceAfter;
    }    
    
    /**
     * @return 変更後 トラックコード
     */
    public org.stormcat.jvbeans.config.code.TrackCd getTrackCdAfter() {
        return trackCdAfter;
    }
    
    /**
     * @param trackCdAfter 変更後 トラックコード
     */
    public void setTrackCdAfter(org.stormcat.jvbeans.config.code.TrackCd trackCdAfter) {
        this.trackCdAfter = trackCdAfter;
    }    
    
    /**
     * @return 変更前 距離
     */
    public java.lang.Integer getDistanceBefore() {
        return distanceBefore;
    }
    
    /**
     * @param distanceBefore 変更前 距離
     */
    public void setDistanceBefore(java.lang.Integer distanceBefore) {
        this.distanceBefore = distanceBefore;
    }    
    
    /**
     * @return 変更前 トラックコード
     */
    public org.stormcat.jvbeans.config.code.TrackCd getTrackCdBefore() {
        return trackCdBefore;
    }
    
    /**
     * @param trackCdBefore 変更前 トラックコード
     */
    public void setTrackCdBefore(org.stormcat.jvbeans.config.code.TrackCd trackCdBefore) {
        this.trackCdBefore = trackCdBefore;
    }    
    
    /**
     * @return 事由区分
     */
    public java.lang.String getReasonDiv() {
        return reasonDiv;
    }
    
    /**
     * @param reasonDiv 事由区分
     */
    public void setReasonDiv(java.lang.String reasonDiv) {
        this.reasonDiv = reasonDiv;
    }    
    
}