/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.BR} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.BR, byteLength = 537)
public class BreederMasterDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 生産者コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 6)
    private java.lang.String breederCd;

    /** 生産者名(法人格有) */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 18, byteLength = 70)
    private java.lang.String breederNameWithCorp;

    /** 生産者名(法人格無) */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 88, byteLength = 70)
    private java.lang.String breederNameWithoutCorp;

    /** 生産者名半角ｶﾅ */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 158, byteLength = 70)
    private java.lang.String breederNameHalfKana;

    /** 生産者名欧字 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 228, byteLength = 168)
    private java.lang.String breederNameEng;

    /** 生産者住所自治省名 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 396, byteLength = 20)
    private java.lang.String breederHomeAffairName;

    /** 本年･累計成績情報 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 416, byteLength = 60, repeatCount = 2)
    private java.util.List<org.stormcat.jvbeans.dto.child.TotalResultInfoSimpleDto> totalResultInfoItems;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 生産者コード
     */
    public java.lang.String getBreederCd() {
        return breederCd;
    }
    
    /**
     * @param breederCd 生産者コード
     */
    public void setBreederCd(java.lang.String breederCd) {
        this.breederCd = breederCd;
    }    
    
    /**
     * @return 生産者名(法人格有)
     */
    public java.lang.String getBreederNameWithCorp() {
        return breederNameWithCorp;
    }
    
    /**
     * @param breederNameWithCorp 生産者名(法人格有)
     */
    public void setBreederNameWithCorp(java.lang.String breederNameWithCorp) {
        this.breederNameWithCorp = breederNameWithCorp;
    }    
    
    /**
     * @return 生産者名(法人格無)
     */
    public java.lang.String getBreederNameWithoutCorp() {
        return breederNameWithoutCorp;
    }
    
    /**
     * @param breederNameWithoutCorp 生産者名(法人格無)
     */
    public void setBreederNameWithoutCorp(java.lang.String breederNameWithoutCorp) {
        this.breederNameWithoutCorp = breederNameWithoutCorp;
    }    
    
    /**
     * @return 生産者名半角ｶﾅ
     */
    public java.lang.String getBreederNameHalfKana() {
        return breederNameHalfKana;
    }
    
    /**
     * @param breederNameHalfKana 生産者名半角ｶﾅ
     */
    public void setBreederNameHalfKana(java.lang.String breederNameHalfKana) {
        this.breederNameHalfKana = breederNameHalfKana;
    }    
    
    /**
     * @return 生産者名欧字
     */
    public java.lang.String getBreederNameEng() {
        return breederNameEng;
    }
    
    /**
     * @param breederNameEng 生産者名欧字
     */
    public void setBreederNameEng(java.lang.String breederNameEng) {
        this.breederNameEng = breederNameEng;
    }    
    
    /**
     * @return 生産者住所自治省名
     */
    public java.lang.String getBreederHomeAffairName() {
        return breederHomeAffairName;
    }
    
    /**
     * @param breederHomeAffairName 生産者住所自治省名
     */
    public void setBreederHomeAffairName(java.lang.String breederHomeAffairName) {
        this.breederHomeAffairName = breederHomeAffairName;
    }    
    
    /**
     * @return 本年･累計成績情報
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.TotalResultInfoSimpleDto> getTotalResultInfoItems() {
        return totalResultInfoItems;
    }
    
    /**
     * @param totalResultInfoItems 本年･累計成績情報
     */
    public void setTotalResultInfoItems(java.util.List<org.stormcat.jvbeans.dto.child.TotalResultInfoSimpleDto> totalResultInfoItems) {
        this.totalResultInfoItems = totalResultInfoItems;
    }      
    
}