/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.config.dataspec;

import org.stormcat.jvbeans.config.RecordTypeId;
import org.stormcat.jvbeans.config.condition.StoredOpenCondition;
import org.stormcat.jvbeans.dto.RaceHorseMarketTradePriceDto;

/**
 * @author a.yamada
 *
 */
public enum _Hose implements org.stormcat.jvbeans.config.dataspec.StoredDataSpec {

    INSTANCE;
    
    public StoredOpenCondition<RaceHorseMarketTradePriceDto> _HS() {
        return new StoredOpenCondition<RaceHorseMarketTradePriceDto>(this, RecordTypeId.HS, RaceHorseMarketTradePriceDto.class);
    }

    /**
     * {@inheritDoc}
     */
    public String getName() {
        return "競走馬市場取引価格情報";
    }

    /**
     * {@inheritDoc}
     */
    public String getValue() {
        return "HOSE";
    }
    
}
