/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.config.dataspec;

import org.stormcat.jvbeans.config.RecordTypeId;
import org.stormcat.jvbeans.config.condition.RealTimeOpenCondition;
import org.stormcat.jvbeans.dto.CancelExclusionDto;
import org.stormcat.jvbeans.dto.CourseChangeDto;
import org.stormcat.jvbeans.dto.JockeyChangeDto;
import org.stormcat.jvbeans.dto.StartTimeChangeDto;
import org.stormcat.jvbeans.dto.WeatherTrackStateDto;


/**
 * @author a.yamada
 *
 */
public enum _0b14 implements org.stormcat.jvbeans.config.dataspec.RealTimeDataSpec {

    INSTANCE;

    public RealTimeOpenCondition<WeatherTrackStateDto> _WE() {
        return new RealTimeOpenCondition<WeatherTrackStateDto>(this, RecordTypeId.WE, WeatherTrackStateDto.class);
    }
    
    public RealTimeOpenCondition<CancelExclusionDto> _AV() {
        return new RealTimeOpenCondition<CancelExclusionDto>(this, RecordTypeId.AV, CancelExclusionDto.class);
    }
    
    public RealTimeOpenCondition<JockeyChangeDto> _JC() {
        return new RealTimeOpenCondition<JockeyChangeDto>(this, RecordTypeId.JC, JockeyChangeDto.class);
    }
    
    public RealTimeOpenCondition<StartTimeChangeDto> _TC() {
        return new RealTimeOpenCondition<StartTimeChangeDto>(this, RecordTypeId.TC, StartTimeChangeDto.class);
    }
    
    public RealTimeOpenCondition<CourseChangeDto> _CC() {
        return new RealTimeOpenCondition<CourseChangeDto>(this, RecordTypeId.CC, CourseChangeDto.class);
    }

    /**
     * {@inheritDoc}
     */
    public String getName() {
        return "速報開催情報";
    }

    /**
     * {@inheritDoc}
     */
    public String getValue() {
        return "0B14";
    }
    
}
