/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.RC} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.RC, byteLength = 501)
public class RecordMasterDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** レコード識別区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 1)
    private java.lang.Integer recordSignDiv;

    /** 開催年 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 13, byteLength = 4)
    private java.lang.Integer holdingYear;

    /** 開催月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 17, byteLength = 4)
    private java.lang.String holdingDate;

    /** 競馬場コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 21, byteLength = 2)
    private org.stormcat.jvbeans.config.code.CourseCd courseCd;

    /** 開催回[第N回] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 23, byteLength = 2)
    private java.lang.String holdingNo;

    /** 開催日目[N日目] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 25, byteLength = 2)
    private java.lang.String holdingDay;

    /** レース番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 27, byteLength = 2)
    private java.lang.String raceNo;

    /** 特別競走番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 29, byteLength = 4)
    private java.lang.String specialRaceNo;

    /** 競走名本題 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 33, byteLength = 60)
    private java.lang.String raceNameFull;

    /** グレードコード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 93, byteLength = 1)
    private org.stormcat.jvbeans.config.code.GradeCd gradeCd;

    /** 競走種別コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 94, byteLength = 2)
    private org.stormcat.jvbeans.config.code.RaceTypeCd raceTypeCd;

    /** 距離 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 96, byteLength = 4)
    private java.lang.Integer distance;

    /** トラックコード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 100, byteLength = 2)
    private org.stormcat.jvbeans.config.code.TrackCd trackCd;

    /** レコード区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 102, byteLength = 1)
    private java.lang.Integer recordDiv;

    /** レコードタイム */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 103, byteLength = 4)
    private java.lang.String recordTime;

    /** 天候コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 107, byteLength = 1)
    private org.stormcat.jvbeans.config.code.WeatherCd weatherCd;

    /** 芝馬場状態コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 108, byteLength = 1)
    private org.stormcat.jvbeans.config.code.CourseConditionCd turfConditionCd;

    /** ダート馬場状態コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 109, byteLength = 1)
    private org.stormcat.jvbeans.config.code.CourseConditionCd dirtConditionCd;

    /** レコード保持馬情報 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 110, byteLength = 130, repeatCount = 3)
    private java.util.List<org.stormcat.jvbeans.dto.child.RecordHolderInfoDto> recordHolderInfoItems;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return レコード識別区分
     */
    public java.lang.Integer getRecordSignDiv() {
        return recordSignDiv;
    }
    
    /**
     * @param recordSignDiv レコード識別区分
     */
    public void setRecordSignDiv(java.lang.Integer recordSignDiv) {
        this.recordSignDiv = recordSignDiv;
    }    
    
    /**
     * @return 開催年
     */
    public java.lang.Integer getHoldingYear() {
        return holdingYear;
    }
    
    /**
     * @param holdingYear 開催年
     */
    public void setHoldingYear(java.lang.Integer holdingYear) {
        this.holdingYear = holdingYear;
    }    
    
    /**
     * @return 開催月日
     */
    public java.lang.String getHoldingDate() {
        return holdingDate;
    }
    
    /**
     * @param holdingDate 開催月日
     */
    public void setHoldingDate(java.lang.String holdingDate) {
        this.holdingDate = holdingDate;
    }    
    
    /**
     * @return 競馬場コード
     */
    public org.stormcat.jvbeans.config.code.CourseCd getCourseCd() {
        return courseCd;
    }
    
    /**
     * @param courseCd 競馬場コード
     */
    public void setCourseCd(org.stormcat.jvbeans.config.code.CourseCd courseCd) {
        this.courseCd = courseCd;
    }    
    
    /**
     * @return 開催回[第N回]
     */
    public java.lang.String getHoldingNo() {
        return holdingNo;
    }
    
    /**
     * @param holdingNo 開催回[第N回]
     */
    public void setHoldingNo(java.lang.String holdingNo) {
        this.holdingNo = holdingNo;
    }    
    
    /**
     * @return 開催日目[N日目]
     */
    public java.lang.String getHoldingDay() {
        return holdingDay;
    }
    
    /**
     * @param holdingDay 開催日目[N日目]
     */
    public void setHoldingDay(java.lang.String holdingDay) {
        this.holdingDay = holdingDay;
    }    
    
    /**
     * @return レース番号
     */
    public java.lang.String getRaceNo() {
        return raceNo;
    }
    
    /**
     * @param raceNo レース番号
     */
    public void setRaceNo(java.lang.String raceNo) {
        this.raceNo = raceNo;
    }    
    
    /**
     * @return 特別競走番号
     */
    public java.lang.String getSpecialRaceNo() {
        return specialRaceNo;
    }
    
    /**
     * @param specialRaceNo 特別競走番号
     */
    public void setSpecialRaceNo(java.lang.String specialRaceNo) {
        this.specialRaceNo = specialRaceNo;
    }    
    
    /**
     * @return 競走名本題
     */
    public java.lang.String getRaceNameFull() {
        return raceNameFull;
    }
    
    /**
     * @param raceNameFull 競走名本題
     */
    public void setRaceNameFull(java.lang.String raceNameFull) {
        this.raceNameFull = raceNameFull;
    }    
    
    /**
     * @return グレードコード
     */
    public org.stormcat.jvbeans.config.code.GradeCd getGradeCd() {
        return gradeCd;
    }
    
    /**
     * @param gradeCd グレードコード
     */
    public void setGradeCd(org.stormcat.jvbeans.config.code.GradeCd gradeCd) {
        this.gradeCd = gradeCd;
    }    
    
    /**
     * @return 競走種別コード
     */
    public org.stormcat.jvbeans.config.code.RaceTypeCd getRaceTypeCd() {
        return raceTypeCd;
    }
    
    /**
     * @param raceTypeCd 競走種別コード
     */
    public void setRaceTypeCd(org.stormcat.jvbeans.config.code.RaceTypeCd raceTypeCd) {
        this.raceTypeCd = raceTypeCd;
    }    
    
    /**
     * @return 距離
     */
    public java.lang.Integer getDistance() {
        return distance;
    }
    
    /**
     * @param distance 距離
     */
    public void setDistance(java.lang.Integer distance) {
        this.distance = distance;
    }    
    
    /**
     * @return トラックコード
     */
    public org.stormcat.jvbeans.config.code.TrackCd getTrackCd() {
        return trackCd;
    }
    
    /**
     * @param trackCd トラックコード
     */
    public void setTrackCd(org.stormcat.jvbeans.config.code.TrackCd trackCd) {
        this.trackCd = trackCd;
    }    
    
    /**
     * @return レコード区分
     */
    public java.lang.Integer getRecordDiv() {
        return recordDiv;
    }
    
    /**
     * @param recordDiv レコード区分
     */
    public void setRecordDiv(java.lang.Integer recordDiv) {
        this.recordDiv = recordDiv;
    }    
    
    /**
     * @return レコードタイム
     */
    public java.lang.String getRecordTime() {
        return recordTime;
    }
    
    /**
     * @param recordTime レコードタイム
     */
    public void setRecordTime(java.lang.String recordTime) {
        this.recordTime = recordTime;
    }    
    
    /**
     * @return 天候コード
     */
    public org.stormcat.jvbeans.config.code.WeatherCd getWeatherCd() {
        return weatherCd;
    }
    
    /**
     * @param weatherCd 天候コード
     */
    public void setWeatherCd(org.stormcat.jvbeans.config.code.WeatherCd weatherCd) {
        this.weatherCd = weatherCd;
    }    
    
    /**
     * @return 芝馬場状態コード
     */
    public org.stormcat.jvbeans.config.code.CourseConditionCd getTurfConditionCd() {
        return turfConditionCd;
    }
    
    /**
     * @param turfConditionCd 芝馬場状態コード
     */
    public void setTurfConditionCd(org.stormcat.jvbeans.config.code.CourseConditionCd turfConditionCd) {
        this.turfConditionCd = turfConditionCd;
    }    
    
    /**
     * @return ダート馬場状態コード
     */
    public org.stormcat.jvbeans.config.code.CourseConditionCd getDirtConditionCd() {
        return dirtConditionCd;
    }
    
    /**
     * @param dirtConditionCd ダート馬場状態コード
     */
    public void setDirtConditionCd(org.stormcat.jvbeans.config.code.CourseConditionCd dirtConditionCd) {
        this.dirtConditionCd = dirtConditionCd;
    }    
    
    /**
     * @return レコード保持馬情報
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.RecordHolderInfoDto> getRecordHolderInfoItems() {
        return recordHolderInfoItems;
    }
    
    /**
     * @param recordHolderInfoItems レコード保持馬情報
     */
    public void setRecordHolderInfoItems(java.util.List<org.stormcat.jvbeans.dto.child.RecordHolderInfoDto> recordHolderInfoItems) {
        this.recordHolderInfoItems = recordHolderInfoItems;
    }      
    
}