/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.O1} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.O1, byteLength = 962)
public class Odds1Dto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 開催年 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 4)
    private java.lang.Integer holdingYear;

    /** 開催月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 16, byteLength = 4)
    private java.lang.String holdingDate;

    /** 競馬場コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 20, byteLength = 2)
    private org.stormcat.jvbeans.config.code.CourseCd courseCd;

    /** 開催回[第N回] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 22, byteLength = 2)
    private java.lang.Integer holdingNo;

    /** 開催日目[N日目] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 24, byteLength = 2)
    private java.lang.Integer holdingDay;

    /** レース番号 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 26, byteLength = 2)
    private java.lang.Integer raceNo;

    /** 発表月日時分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 28, byteLength = 8)
    private java.util.Date announceDate;

    /** 登録頭数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 36, byteLength = 2)
    private java.lang.Integer entryCount;

    /** 出走頭数 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 38, byteLength = 2)
    private java.lang.Integer starterCount;

    /** 発売フラグ　単勝 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 40, byteLength = 1)
    private java.lang.Integer saleFlgWin;

    /** 発売フラグ　複勝 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 41, byteLength = 1)
    private java.lang.Integer saleFlgShow;

    /** 発売フラグ　枠連 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 42, byteLength = 1)
    private java.lang.Integer saleFlgbracket;

    /** 複勝着払キー */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 43, byteLength = 1)
    private java.lang.Integer showCashKey;

    /** 単勝オッズ */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 44, byteLength = 8, repeatCount = 28)
    private java.util.List<org.stormcat.jvbeans.dto.child.WinOddsDto> winOddsItems;

    /** 複勝オッズ */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 268, byteLength = 12, repeatCount = 28)
    private java.util.List<org.stormcat.jvbeans.dto.child.ShowOddsDto> showOddsItems;

    /** 枠連オッズ */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 604, byteLength = 9, repeatCount = 36)
    private java.util.List<org.stormcat.jvbeans.dto.child.BracketOddsDto> bracketOddsItems;

    /** 単勝票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 928, byteLength = 11)
    private java.lang.String voteTotalCountWin;

    /** 複勝票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 939, byteLength = 11)
    private java.lang.String voteTotalCountShow;

    /** 枠連票数合計 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 950, byteLength = 11)
    private java.lang.String voteTotalCountBracket;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 開催年
     */
    public java.lang.Integer getHoldingYear() {
        return holdingYear;
    }
    
    /**
     * @param holdingYear 開催年
     */
    public void setHoldingYear(java.lang.Integer holdingYear) {
        this.holdingYear = holdingYear;
    }    
    
    /**
     * @return 開催月日
     */
    public java.lang.String getHoldingDate() {
        return holdingDate;
    }
    
    /**
     * @param holdingDate 開催月日
     */
    public void setHoldingDate(java.lang.String holdingDate) {
        this.holdingDate = holdingDate;
    }    
    
    /**
     * @return 競馬場コード
     */
    public org.stormcat.jvbeans.config.code.CourseCd getCourseCd() {
        return courseCd;
    }
    
    /**
     * @param courseCd 競馬場コード
     */
    public void setCourseCd(org.stormcat.jvbeans.config.code.CourseCd courseCd) {
        this.courseCd = courseCd;
    }    
    
    /**
     * @return 開催回[第N回]
     */
    public java.lang.Integer getHoldingNo() {
        return holdingNo;
    }
    
    /**
     * @param holdingNo 開催回[第N回]
     */
    public void setHoldingNo(java.lang.Integer holdingNo) {
        this.holdingNo = holdingNo;
    }    
    
    /**
     * @return 開催日目[N日目]
     */
    public java.lang.Integer getHoldingDay() {
        return holdingDay;
    }
    
    /**
     * @param holdingDay 開催日目[N日目]
     */
    public void setHoldingDay(java.lang.Integer holdingDay) {
        this.holdingDay = holdingDay;
    }    
    
    /**
     * @return レース番号
     */
    public java.lang.Integer getRaceNo() {
        return raceNo;
    }
    
    /**
     * @param raceNo レース番号
     */
    public void setRaceNo(java.lang.Integer raceNo) {
        this.raceNo = raceNo;
    }    
    
    /**
     * @return 発表月日時分
     */
    public java.util.Date getAnnounceDate() {
        return announceDate;
    }
    
    /**
     * @param announceDate 発表月日時分
     */
    public void setAnnounceDate(java.util.Date announceDate) {
        this.announceDate = announceDate;
    }    
    
    /**
     * @return 登録頭数
     */
    public java.lang.Integer getEntryCount() {
        return entryCount;
    }
    
    /**
     * @param entryCount 登録頭数
     */
    public void setEntryCount(java.lang.Integer entryCount) {
        this.entryCount = entryCount;
    }    
    
    /**
     * @return 出走頭数
     */
    public java.lang.Integer getStarterCount() {
        return starterCount;
    }
    
    /**
     * @param starterCount 出走頭数
     */
    public void setStarterCount(java.lang.Integer starterCount) {
        this.starterCount = starterCount;
    }    
    
    /**
     * @return 発売フラグ　単勝
     */
    public java.lang.Integer getSaleFlgWin() {
        return saleFlgWin;
    }
    
    /**
     * @param saleFlgWin 発売フラグ　単勝
     */
    public void setSaleFlgWin(java.lang.Integer saleFlgWin) {
        this.saleFlgWin = saleFlgWin;
    }    
    
    /**
     * @return 発売フラグ　複勝
     */
    public java.lang.Integer getSaleFlgShow() {
        return saleFlgShow;
    }
    
    /**
     * @param saleFlgShow 発売フラグ　複勝
     */
    public void setSaleFlgShow(java.lang.Integer saleFlgShow) {
        this.saleFlgShow = saleFlgShow;
    }    
    
    /**
     * @return 発売フラグ　枠連
     */
    public java.lang.Integer getSaleFlgbracket() {
        return saleFlgbracket;
    }
    
    /**
     * @param saleFlgbracket 発売フラグ　枠連
     */
    public void setSaleFlgbracket(java.lang.Integer saleFlgbracket) {
        this.saleFlgbracket = saleFlgbracket;
    }    
    
    /**
     * @return 複勝着払キー
     */
    public java.lang.Integer getShowCashKey() {
        return showCashKey;
    }
    
    /**
     * @param showCashKey 複勝着払キー
     */
    public void setShowCashKey(java.lang.Integer showCashKey) {
        this.showCashKey = showCashKey;
    }    
    
    /**
     * @return 単勝オッズ
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.WinOddsDto> getWinOddsItems() {
        return winOddsItems;
    }
    
    /**
     * @param winOddsItems 単勝オッズ
     */
    public void setWinOddsItems(java.util.List<org.stormcat.jvbeans.dto.child.WinOddsDto> winOddsItems) {
        this.winOddsItems = winOddsItems;
    }      
    
    /**
     * @return 複勝オッズ
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.ShowOddsDto> getShowOddsItems() {
        return showOddsItems;
    }
    
    /**
     * @param showOddsItems 複勝オッズ
     */
    public void setShowOddsItems(java.util.List<org.stormcat.jvbeans.dto.child.ShowOddsDto> showOddsItems) {
        this.showOddsItems = showOddsItems;
    }      
    
    /**
     * @return 枠連オッズ
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.BracketOddsDto> getBracketOddsItems() {
        return bracketOddsItems;
    }
    
    /**
     * @param bracketOddsItems 枠連オッズ
     */
    public void setBracketOddsItems(java.util.List<org.stormcat.jvbeans.dto.child.BracketOddsDto> bracketOddsItems) {
        this.bracketOddsItems = bracketOddsItems;
    }      
    
    /**
     * @return 単勝票数合計
     */
    public java.lang.String getVoteTotalCountWin() {
        return voteTotalCountWin;
    }
    
    /**
     * @param voteTotalCountWin 単勝票数合計
     */
    public void setVoteTotalCountWin(java.lang.String voteTotalCountWin) {
        this.voteTotalCountWin = voteTotalCountWin;
    }    
    
    /**
     * @return 複勝票数合計
     */
    public java.lang.String getVoteTotalCountShow() {
        return voteTotalCountShow;
    }
    
    /**
     * @param voteTotalCountShow 複勝票数合計
     */
    public void setVoteTotalCountShow(java.lang.String voteTotalCountShow) {
        this.voteTotalCountShow = voteTotalCountShow;
    }    
    
    /**
     * @return 枠連票数合計
     */
    public java.lang.String getVoteTotalCountBracket() {
        return voteTotalCountBracket;
    }
    
    /**
     * @param voteTotalCountBracket 枠連票数合計
     */
    public void setVoteTotalCountBracket(java.lang.String voteTotalCountBracket) {
        this.voteTotalCountBracket = voteTotalCountBracket;
    }    
    
}