/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.dto;
 
 /**
 * レコードフォーマットID {@link org.stormcat.jvbeans.config.RecordTypeId.YS} に対応するDtoです。
 * @author jv-beans-gen
 *
 */
@org.stormcat.jvbeans.annotation.JvBean(recordTypeId = org.stormcat.jvbeans.config.RecordTypeId.YS, byteLength = 382)
public class HoldingScheduleDto extends org.stormcat.jvbeans.jvlink.JvBindingDto {

    /** レコード種別ID */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 1, byteLength = 2)
    private org.stormcat.jvbeans.config.RecordTypeId recordTypeId;

    /** データ区分 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 3, byteLength = 1)
    private java.lang.String dataDiv;

    /** データ作成年月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 4, byteLength = 8)
    private java.util.Date dataCreateDate;

    /** 開催年 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 12, byteLength = 4)
    private java.lang.Integer holdingYear;

    /** 開催月日 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 16, byteLength = 4)
    private java.lang.String holdingDate;

    /** 競馬場コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 20, byteLength = 2)
    private org.stormcat.jvbeans.config.code.CourseCd courseCd;

    /** 開催回[第N回] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 22, byteLength = 2)
    private java.lang.Integer holdingNo;

    /** 開催日目[N日目] */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 24, byteLength = 2)
    private java.lang.Integer holdingDay;

    /** 曜日コード */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 26, byteLength = 1)
    private org.stormcat.jvbeans.config.code.WeekDayCd weekDayCd;

    /** 重賞案内 */
    @org.stormcat.jvbeans.annotation.JvProperty(position = 27, byteLength = 118, repeatCount = 3)
    private java.util.List<org.stormcat.jvbeans.dto.child.GradeInformationDto> gradeInformationItems;


    /**
     * @return レコード種別ID
     */
    public org.stormcat.jvbeans.config.RecordTypeId getRecordTypeId() {
        return recordTypeId;
    }
    
    /**
     * @param recordTypeId レコード種別ID
     */
    public void setRecordTypeId(org.stormcat.jvbeans.config.RecordTypeId recordTypeId) {
        this.recordTypeId = recordTypeId;
    }    
    
    /**
     * @return データ区分
     */
    public java.lang.String getDataDiv() {
        return dataDiv;
    }
    
    /**
     * @param dataDiv データ区分
     */
    public void setDataDiv(java.lang.String dataDiv) {
        this.dataDiv = dataDiv;
    }    
    
    /**
     * @return データ作成年月日
     */
    public java.util.Date getDataCreateDate() {
        return dataCreateDate;
    }
    
    /**
     * @param dataCreateDate データ作成年月日
     */
    public void setDataCreateDate(java.util.Date dataCreateDate) {
        this.dataCreateDate = dataCreateDate;
    }    
    
    /**
     * @return 開催年
     */
    public java.lang.Integer getHoldingYear() {
        return holdingYear;
    }
    
    /**
     * @param holdingYear 開催年
     */
    public void setHoldingYear(java.lang.Integer holdingYear) {
        this.holdingYear = holdingYear;
    }    
    
    /**
     * @return 開催月日
     */
    public java.lang.String getHoldingDate() {
        return holdingDate;
    }
    
    /**
     * @param holdingDate 開催月日
     */
    public void setHoldingDate(java.lang.String holdingDate) {
        this.holdingDate = holdingDate;
    }    
    
    /**
     * @return 競馬場コード
     */
    public org.stormcat.jvbeans.config.code.CourseCd getCourseCd() {
        return courseCd;
    }
    
    /**
     * @param courseCd 競馬場コード
     */
    public void setCourseCd(org.stormcat.jvbeans.config.code.CourseCd courseCd) {
        this.courseCd = courseCd;
    }    
    
    /**
     * @return 開催回[第N回]
     */
    public java.lang.Integer getHoldingNo() {
        return holdingNo;
    }
    
    /**
     * @param holdingNo 開催回[第N回]
     */
    public void setHoldingNo(java.lang.Integer holdingNo) {
        this.holdingNo = holdingNo;
    }    
    
    /**
     * @return 開催日目[N日目]
     */
    public java.lang.Integer getHoldingDay() {
        return holdingDay;
    }
    
    /**
     * @param holdingDay 開催日目[N日目]
     */
    public void setHoldingDay(java.lang.Integer holdingDay) {
        this.holdingDay = holdingDay;
    }    
    
    /**
     * @return 曜日コード
     */
    public org.stormcat.jvbeans.config.code.WeekDayCd getWeekDayCd() {
        return weekDayCd;
    }
    
    /**
     * @param weekDayCd 曜日コード
     */
    public void setWeekDayCd(org.stormcat.jvbeans.config.code.WeekDayCd weekDayCd) {
        this.weekDayCd = weekDayCd;
    }    
    
    /**
     * @return 重賞案内
     */
    public java.util.List<org.stormcat.jvbeans.dto.child.GradeInformationDto> getGradeInformationItems() {
        return gradeInformationItems;
    }
    
    /**
     * @param gradeInformationItems 重賞案内
     */
    public void setGradeInformationItems(java.util.List<org.stormcat.jvbeans.dto.child.GradeInformationDto> gradeInformationItems) {
        this.gradeInformationItems = gradeInformationItems;
    }      
    
}