/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.config.dataspec;

import org.stormcat.jvbeans.config.RecordTypeId;
import org.stormcat.jvbeans.config.condition.StoredOpenCondition;
import org.stormcat.jvbeans.dto.BreederMasterDto;
import org.stormcat.jvbeans.dto.HorseRaceInfoDto;
import org.stormcat.jvbeans.dto.JockeyMasterDto;
import org.stormcat.jvbeans.dto.OwnerMasterDto;
import org.stormcat.jvbeans.dto.RaceDetailDto;
import org.stormcat.jvbeans.dto.RaceHorseMasterDto;
import org.stormcat.jvbeans.dto.RecordMasterDto;
import org.stormcat.jvbeans.dto.TrainerMasterDto;

/**
 * @author a.yamada
 *
 */
public enum _Rcov implements org.stormcat.jvbeans.config.dataspec.StoredDataSpec {
    
    INSTANCE;

    public StoredOpenCondition<RaceHorseMasterDto> _UM() {
        return new StoredOpenCondition<RaceHorseMasterDto>(this, RecordTypeId.UM, RaceHorseMasterDto.class);
    }
    
    public StoredOpenCondition<JockeyMasterDto> _KS() {
        return new StoredOpenCondition<JockeyMasterDto>(this, RecordTypeId.KS, JockeyMasterDto.class);
    }
    
    public StoredOpenCondition<TrainerMasterDto> _CH() {
        return new StoredOpenCondition<TrainerMasterDto>(this, RecordTypeId.CH, TrainerMasterDto.class);
    }
    
    public StoredOpenCondition<BreederMasterDto> _BR() {
        return new StoredOpenCondition<BreederMasterDto>(this, RecordTypeId.BR, BreederMasterDto.class);
    }
    
    public StoredOpenCondition<OwnerMasterDto> _BN() {
        return new StoredOpenCondition<OwnerMasterDto>(this, RecordTypeId.BN, OwnerMasterDto.class);
    }
    
    public StoredOpenCondition<RecordMasterDto> _RC() {
        return new StoredOpenCondition<RecordMasterDto>(this, RecordTypeId.RC, RecordMasterDto.class);
    }
    
    public StoredOpenCondition<RaceDetailDto> _RA() {
        return new StoredOpenCondition<RaceDetailDto>(this, RecordTypeId.RA, RaceDetailDto.class);
    }
    
    public StoredOpenCondition<HorseRaceInfoDto> _SE() {
        return new StoredOpenCondition<HorseRaceInfoDto>(this, RecordTypeId.SE, HorseRaceInfoDto.class);
    }

    /**
     * {@inheritDoc}
     */
    public String getName() {
        return "非蓄積系ソフト用　補てん情報（レース情報補てん）";
    }

    /**
     * {@inheritDoc}
     */
    public String getValue() {
        return "RCOV";
    }

}
