/*
 * Copyright 2009 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.config.code;
 
/**
 * <b>2202.性別コード</b> のEnumによる表現です。
 * @author jv-beans-gen
 *
*/
public enum SexCd implements org.stormcat.commons.constants.PairValueEnum<Integer> {

    /** 未設定・未整備時の初期値(主に地方競馬・海外国際レースに関するデータ) */
    UNKNOWN("未設定・未整備時の初期値(主に地方競馬・海外国際レースに関するデータ)", 0, ""),
    
    /** 牡馬 */
    MALE("牡馬", 1, "満年齢0～4歳　C, 満年齢5歳～ 　H"),
    
    /** 牝馬 */
    FEMALE("牝馬", 2, "満年齢0～4歳　F, 満年齢5歳～ 　M"),
    
    /** セン馬 */
    GELDINGS("セン馬", 3, "満年齢0～4歳　G, 満年齢5歳～ 　G"),
    
    ;

    /** 名称 */
    private String name;
    
    /** 値 */
    private Integer value;
    
    /** 欧字名 */
    private String nameEng;
    
    private SexCd(String name, Integer value, String nameEng) {
        this.name = name;
        this.value = value;
        this.nameEng = nameEng;
    }
    
    /**
     * {@inheritDoc}
     */
    public String getName() {
        return this.name;
    }    

    /**
     * {@inheritDoc}
     */
    public Integer getValue() {
        return this.value;
    }
    
    /**
     * 欧字名 を返します。
     * @return 欧字名 
     */
    public String getNameEng() {
        return this.nameEng;
    }
    
}