/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.analyze;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.stormcat.commons.reflect.FieldUtil;
import org.stormcat.commons.reflect.GenericsUtil;
import org.stormcat.jvbeans.annotation.JvProperty;
import org.stormcat.jvbeans.jvlink.analyze.JvRecordMeta;

public class JvRecordMetaFactory {
    private JvRecordMetaFactory() {
    }

    public static JvRecordMeta create(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("\u30d5\u30a3\u30fc\u30eb\u30c9\u304cnull\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
        }
        JvProperty jvProperty = field.getAnnotation(JvProperty.class);
        if (jvProperty == null) {
            return null;
        }
        Class<?> type = field.getType();
        if (type == List.class) {
            Class genericClass = GenericsUtil.getRowClass((Type)((ParameterizedType)ParameterizedType.class.cast(field.getGenericType())).getActualTypeArguments()[0]);
            ArrayList<JvRecordMeta> metaItems = null;
            if (jvProperty.join()) {
                metaItems = new ArrayList<JvRecordMeta>();
                for (Field f : genericClass.getDeclaredFields()) {
                    metaItems.add(JvRecordMetaFactory.create(f));
                }
            }
            return new JvRecordMeta(jvProperty.position(), jvProperty.byteLength(), jvProperty.repeatCount(), genericClass, FieldUtil.getSetterMethod((Field)field), Float.valueOf(jvProperty.correction()), metaItems);
        }
        return new JvRecordMeta(jvProperty.position(), jvProperty.byteLength(), jvProperty.repeatCount(), field.getType(), FieldUtil.getSetterMethod((Field)field), Float.valueOf(jvProperty.correction()));
    }
}

