/*
 * Decompiled with CFR 0.152.
 */
package com.jacob.com;

import com.jacob.com.Currency;
import com.jacob.com.Dispatch;
import com.jacob.com.JacobException;
import com.jacob.com.NotImplementedException;
import com.jacob.com.SafeArray;
import com.jacob.com.Variant;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Date;

public final class VariantUtilities {
    private static final BigDecimal LARGEST_DECIMAL = new BigDecimal(new BigInteger("ffffffffffffffffffffffff", 16));
    private static final BigDecimal SMALLEST_DECIMAL = new BigDecimal(new BigInteger("ffffffffffffffffffffffff", 16).negate());

    private VariantUtilities() {
    }

    protected static void populateVariant(Variant targetVariant, Object pValueObject, boolean fByRef) {
        if (pValueObject == null) {
            targetVariant.putEmpty();
        } else if (pValueObject instanceof Integer) {
            if (fByRef) {
                targetVariant.putIntRef((Integer)pValueObject);
            } else {
                targetVariant.putInt((Integer)pValueObject);
            }
        } else if (pValueObject instanceof Short) {
            if (fByRef) {
                targetVariant.putShortRef((Short)pValueObject);
            } else {
                targetVariant.putShort((Short)pValueObject);
            }
        } else if (pValueObject instanceof String) {
            if (fByRef) {
                targetVariant.putStringRef((String)pValueObject);
            } else {
                targetVariant.putString((String)pValueObject);
            }
        } else if (pValueObject instanceof Boolean) {
            if (fByRef) {
                targetVariant.putBooleanRef((Boolean)pValueObject);
            } else {
                targetVariant.putBoolean((Boolean)pValueObject);
            }
        } else if (pValueObject instanceof Double) {
            if (fByRef) {
                targetVariant.putDoubleRef((Double)pValueObject);
            } else {
                targetVariant.putDouble((Double)pValueObject);
            }
        } else if (pValueObject instanceof Float) {
            if (fByRef) {
                targetVariant.putFloatRef(((Float)pValueObject).floatValue());
            } else {
                targetVariant.putFloat(((Float)pValueObject).floatValue());
            }
        } else if (pValueObject instanceof BigDecimal) {
            if (fByRef) {
                targetVariant.putDecimalRef((BigDecimal)pValueObject);
            } else {
                targetVariant.putDecimal((BigDecimal)pValueObject);
            }
        } else if (pValueObject instanceof Byte) {
            if (fByRef) {
                targetVariant.putByteRef((Byte)pValueObject);
            } else {
                targetVariant.putByte((Byte)pValueObject);
            }
        } else if (pValueObject instanceof Date) {
            if (fByRef) {
                targetVariant.putDateRef((Date)pValueObject);
            } else {
                targetVariant.putDate((Date)pValueObject);
            }
        } else if (pValueObject instanceof Long) {
            if (fByRef) {
                targetVariant.putLongRef((Long)pValueObject);
            } else {
                targetVariant.putLong((Long)pValueObject);
            }
        } else if (pValueObject instanceof Currency) {
            if (fByRef) {
                targetVariant.putCurrencyRef((Currency)pValueObject);
            } else {
                targetVariant.putCurrency((Currency)pValueObject);
            }
        } else if (pValueObject instanceof SafeArray) {
            if (fByRef) {
                targetVariant.putSafeArrayRef((SafeArray)pValueObject);
            } else {
                targetVariant.putSafeArray((SafeArray)pValueObject);
            }
        } else if (pValueObject instanceof Dispatch) {
            if (fByRef) {
                targetVariant.putDispatchRef((Dispatch)pValueObject);
            } else {
                targetVariant.putDispatch((Dispatch)pValueObject);
            }
        } else if (pValueObject instanceof Variant) {
            targetVariant.putVariant(pValueObject);
        } else {
            throw new NotImplementedException("populateVariant() not implemented for " + pValueObject.getClass());
        }
    }

    protected static Variant objectToVariant(Object objectToBeMadeIntoVariant) {
        if (objectToBeMadeIntoVariant == null) {
            return new Variant();
        }
        if (objectToBeMadeIntoVariant instanceof Variant) {
            return (Variant)objectToBeMadeIntoVariant;
        }
        if (objectToBeMadeIntoVariant.getClass().isArray()) {
            SafeArray sa = null;
            int len1 = Array.getLength(objectToBeMadeIntoVariant);
            Class<?> componentType = objectToBeMadeIntoVariant.getClass().getComponentType();
            if (componentType.isArray()) {
                Object e1;
                int max = 0;
                int i = 0;
                while (i < len1) {
                    e1 = Array.get(objectToBeMadeIntoVariant, i);
                    int len2 = Array.getLength(e1);
                    if (max < len2) {
                        max = len2;
                    }
                    ++i;
                }
                sa = new SafeArray(12, len1, max);
                i = 0;
                while (i < len1) {
                    e1 = Array.get(objectToBeMadeIntoVariant, i);
                    int j = 0;
                    while (j < Array.getLength(e1)) {
                        sa.setVariant(i, j, VariantUtilities.objectToVariant(Array.get(e1, j)));
                        ++j;
                    }
                    ++i;
                }
            } else if (Byte.TYPE.equals(componentType)) {
                byte[] arr = (byte[])objectToBeMadeIntoVariant;
                sa = new SafeArray(17, len1);
                int i = 0;
                while (i < len1) {
                    sa.setByte(i, arr[i]);
                    ++i;
                }
            } else if (Integer.TYPE.equals(componentType)) {
                int[] arr = (int[])objectToBeMadeIntoVariant;
                sa = new SafeArray(3, len1);
                int i = 0;
                while (i < len1) {
                    sa.setInt(i, arr[i]);
                    ++i;
                }
            } else if (Double.TYPE.equals(componentType)) {
                double[] arr = (double[])objectToBeMadeIntoVariant;
                sa = new SafeArray(5, len1);
                int i = 0;
                while (i < len1) {
                    sa.setDouble(i, arr[i]);
                    ++i;
                }
            } else if (Long.TYPE.equals(componentType)) {
                long[] arr = (long[])objectToBeMadeIntoVariant;
                sa = new SafeArray(20, len1);
                int i = 0;
                while (i < len1) {
                    sa.setLong(i, arr[i]);
                    ++i;
                }
            } else {
                sa = new SafeArray(12, len1);
                int i = 0;
                while (i < len1) {
                    sa.setVariant(i, VariantUtilities.objectToVariant(Array.get(objectToBeMadeIntoVariant, i)));
                    ++i;
                }
            }
            Variant returnVariant = new Variant();
            VariantUtilities.populateVariant(returnVariant, sa, false);
            return returnVariant;
        }
        Variant returnVariant = new Variant();
        VariantUtilities.populateVariant(returnVariant, objectToBeMadeIntoVariant, false);
        return returnVariant;
    }

    protected static Variant[] objectsToVariants(Object[] arrayOfObjectsToBeConverted) {
        Variant[] vArg = new Variant[arrayOfObjectsToBeConverted.length];
        int i = 0;
        while (i < arrayOfObjectsToBeConverted.length) {
            vArg[i] = VariantUtilities.objectToVariant(arrayOfObjectsToBeConverted[i]);
            ++i;
        }
        return vArg;
    }

    protected static Object variantToObject(Variant sourceData) {
        Object result = null;
        short type = sourceData.getvt();
        if ((type & 0x2000) == 8192) {
            SafeArray array = null;
            type = (short)(type - 8192);
            array = sourceData.toSafeArray();
            result = array;
        } else {
            switch (type) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    result = new Short(sourceData.getShort());
                    break;
                }
                case 16386: {
                    result = new Short(sourceData.getShortRef());
                    break;
                }
                case 3: {
                    result = new Integer(sourceData.getInt());
                    break;
                }
                case 16387: {
                    result = new Integer(sourceData.getIntRef());
                    break;
                }
                case 4: {
                    result = new Float(sourceData.getFloat());
                    break;
                }
                case 16388: {
                    result = new Float(sourceData.getFloatRef());
                    break;
                }
                case 5: {
                    result = new Double(sourceData.getDouble());
                    break;
                }
                case 16389: {
                    result = new Double(sourceData.getDoubleRef());
                    break;
                }
                case 6: {
                    result = sourceData.getCurrency();
                    break;
                }
                case 16390: {
                    result = sourceData.getCurrencyRef();
                    break;
                }
                case 7: {
                    result = sourceData.getJavaDate();
                    break;
                }
                case 16391: {
                    result = sourceData.getJavaDateRef();
                    break;
                }
                case 8: {
                    result = sourceData.getString();
                    break;
                }
                case 16392: {
                    result = sourceData.getStringRef();
                    break;
                }
                case 9: {
                    result = sourceData.getDispatch();
                    break;
                }
                case 16393: {
                    result = sourceData.getDispatchRef();
                    break;
                }
                case 10: {
                    result = new NotImplementedException("toJavaObject() Not implemented for VariantError");
                    break;
                }
                case 11: {
                    result = new Boolean(sourceData.getBoolean());
                    break;
                }
                case 16395: {
                    result = new Boolean(sourceData.getBooleanRef());
                    break;
                }
                case 12: {
                    result = new NotImplementedException("toJavaObject() Not implemented for VariantVariant without ByRef");
                    break;
                }
                case 16396: {
                    result = sourceData.getVariant();
                    break;
                }
                case 13: {
                    result = new NotImplementedException("toJavaObject() Not implemented for VariantObject");
                    break;
                }
                case 14: {
                    result = sourceData.getDecimal();
                    break;
                }
                case 16398: {
                    result = sourceData.getDecimalRef();
                    break;
                }
                case 17: {
                    result = new Byte(sourceData.getByte());
                    break;
                }
                case 16401: {
                    result = new Byte(sourceData.getByteRef());
                    break;
                }
                case 20: {
                    result = new Long(sourceData.getLong());
                    break;
                }
                case 16404: {
                    result = new Long(sourceData.getLongRef());
                    break;
                }
                case 4095: {
                    result = new NotImplementedException("toJavaObject() Not implemented for VariantTypeMask");
                    break;
                }
                case 8192: {
                    result = new NotImplementedException("toJavaObject() Not implemented for VariantArray");
                    break;
                }
                case 16384: {
                    result = new NotImplementedException("toJavaObject() Not implemented for VariantByref");
                    break;
                }
                default: {
                    result = new NotImplementedException("Unknown return type: " + type);
                }
            }
            if (result instanceof JacobException) {
                throw (JacobException)result;
            }
        }
        return result;
    }

    protected static void validateDecimalScaleAndBits(BigDecimal in) {
        BigInteger allWordBigInt = in.unscaledValue();
        if (in.scale() > 28) {
            throw new IllegalArgumentException("VT_DECIMAL only supports a maximum scale of 28 and the passed in value has a scale of " + in.scale());
        }
        if (in.scale() < 0) {
            throw new IllegalArgumentException("VT_DECIMAL only supports a minimum scale of 0 and the passed in value has a scale of " + in.scale());
        }
        if (allWordBigInt.bitLength() > 96) {
            throw new IllegalArgumentException("VT_DECIMAL supports a maximum of 96 bits not counting scale and the number passed in has " + allWordBigInt.bitLength());
        }
    }

    protected static void validateDecimalMinMax(BigDecimal in) {
        if (in == null) {
            throw new IllegalArgumentException("null is not a supported Decimal value.");
        }
        if (LARGEST_DECIMAL.compareTo(in) < 0) {
            throw new IllegalArgumentException("Value too large for VT_DECIMAL data type:" + in.toString() + " integer: " + in.toBigInteger().toString(16) + " scale: " + in.scale());
        }
        if (SMALLEST_DECIMAL.compareTo(in) > 0) {
            throw new IllegalArgumentException("Value too small for VT_DECIMAL data type:" + in.toString() + " integer: " + in.toBigInteger().toString(16) + " scale: " + in.scale());
        }
    }

    public static BigDecimal roundToMSDecimal(BigDecimal sourceDecimal) {
        BigInteger sourceDecimalIntComponent = sourceDecimal.unscaledValue();
        BigDecimal destinationDecimal = new BigDecimal(sourceDecimalIntComponent, sourceDecimal.scale());
        int roundingModel = 4;
        VariantUtilities.validateDecimalMinMax(destinationDecimal);
        BigInteger allWordBigInt = destinationDecimal.unscaledValue();
        if (allWordBigInt.bitLength() > 96) {
            destinationDecimal = destinationDecimal.round(new MathContext(29));
            if (allWordBigInt.bitLength() > 96) {
                destinationDecimal = destinationDecimal.round(new MathContext(28));
            }
        }
        if (destinationDecimal.scale() > 28) {
            destinationDecimal = destinationDecimal.setScale(28, roundingModel);
        }
        if (destinationDecimal.scale() < 0) {
            destinationDecimal = destinationDecimal.setScale(0, roundingModel);
        }
        return destinationDecimal;
    }
}

