/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.form;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import jpiere.plugin.groupware.form.TeamMemberListModel;
import jpiere.plugin.groupware.form.TeamMemberListRowRenderer;
import jpiere.plugin.groupware.form.TeamMemberModel;
import jpiere.plugin.groupware.window.ToDoPopupWindow;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MTable;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Center;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Div;
import org.zkoss.zul.Grid;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Popup;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.South;

public class TeamMemberPopup
extends Popup
implements EventListener<Event> {
    private Properties ctx = Env.getCtx();
    private Button zoomTeamBtn = null;
    private ToDoPopupWindow todoPopupWindow = null;
    private int JP_Team_ID = 0;

    public TeamMemberPopup(ToDoPopupWindow todoPopupWindow) throws Exception {
        this.todoPopupWindow = todoPopupWindow;
        this.JP_Team_ID = todoPopupWindow.getJP_Team_ID();
        this.zoomTeamBtn = ButtonFactory.createButton((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Zoom"), null, (String)"");
        if (ThemeManager.isUseFontIconForImage()) {
            this.zoomTeamBtn.setIconSclass("z-icon-Zoom");
        } else {
            this.zoomTeamBtn.setImage(ThemeManager.getThemeResource((String)"images/Zoom16.png"));
        }
        this.zoomTeamBtn.setName("ZOOM");
        this.zoomTeamBtn.addEventListener("onClick", (EventListener)this);
        if (this.JP_Team_ID == 0) {
            this.appendChild((Component)this.zoomTeamBtn);
            return;
        }
        StringBuilder sqlSELECT = new StringBuilder("SELECT ");
        StringBuilder sqlFROM = new StringBuilder(" FROM JP_Team_Member INNER JOIN AD_User ON (JP_Team_Member.AD_User_ID = AD_User.AD_User_ID) ");
        StringBuilder sqlWHERE = new StringBuilder(" WHERE JP_Team_Member.JP_Team_ID = ? ");
        StringBuilder sqlOrder = new StringBuilder(" ORDER BY JP_Team_Member.AD_User_ID");
        sqlSELECT.append(" JP_Team_Member.AD_User_ID");
        String eSql = MLookupFactory.getLookup_TableDirEmbed((Language)Env.getLanguage((Properties)this.ctx), (String)"AD_User_ID", (String)"JP_Team_Member");
        sqlSELECT.append(", (").append(eSql).append(") AS User");
        sqlSELECT.append(", AD_User.EMail");
        StringBuilder sql = sqlSELECT.append((CharSequence)sqlFROM).append((CharSequence)sqlWHERE).append((CharSequence)sqlOrder);
        ArrayList<TeamMemberModel> list = new ArrayList<TeamMemberModel>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setInt(1, this.JP_Team_ID);
            rs = pstmt.executeQuery();
            TeamMemberModel todo = null;
            while (rs.next()) {
                todo = new TeamMemberModel();
                todo.AD_User_ID = rs.getInt(1);
                todo.user = rs.getString(2);
                todo.EMail = rs.getString(3);
                list.add(todo);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (list.size() == 0) {
            Div div = new Div();
            this.appendChild((Component)div);
            div.appendChild((Component)new Label(Msg.getMsg((Properties)this.ctx, (String)"not.found")));
            div = new Div();
            this.appendChild((Component)div);
            div.appendChild((Component)this.zoomTeamBtn);
            return;
        }
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, (String)"420px");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, (String)"380px");
        Borderlayout popupContent = new Borderlayout();
        this.appendChild((Component)popupContent);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)popupContent, (String)"max");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)popupContent, (String)"min");
        Center center = new Center();
        popupContent.appendChild((Component)center);
        Grid grid = new Grid();
        ZKUpdateUtil.setVflex((Grid)grid, (boolean)true);
        grid.setMold("paging");
        grid.setPageSize(10);
        grid.setPagingPosition("top");
        center.appendChild((Component)grid);
        Columns columns = new Columns();
        grid.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        column.setLabel(Msg.getElement((Properties)this.ctx, (String)"AD_User_ID"));
        column = new Column();
        columns.appendChild((Component)column);
        column.setLabel(Msg.getElement((Properties)this.ctx, (String)"EMail"));
        TeamMemberListModel listModel = new TeamMemberListModel(list);
        grid.setModel((ListModel)listModel);
        TeamMemberListRowRenderer rowRenderer = new TeamMemberListRowRenderer(this);
        grid.setRowRenderer((RowRenderer)rowRenderer);
        South south = new South();
        popupContent.appendChild((Component)south);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.zoomTeamBtn, (String)"max");
        south.appendChild((Component)this.zoomTeamBtn);
    }

    public void onEvent(Event event) throws Exception {
        AEnv.zoom((int)MTable.getTable_ID((String)"JP_Team"), (int)this.JP_Team_ID);
        this.todoPopupWindow.dispose();
        this.detach();
    }
}

