/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.window;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import jpiere.plugin.groupware.model.MToDoTeamReminder;
import jpiere.plugin.groupware.window.PersonalToDoReminderListWindow;
import jpiere.plugin.groupware.window.PersonalToDoReminderModel;
import org.adempiere.webui.component.Label;
import org.compiere.model.MColumn;
import org.compiere.model.MRefList;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;

public class PersonalToDoReminderListRowRenderer
implements RowRenderer<PersonalToDoReminderModel> {
    private PersonalToDoReminderListWindow personalToDoReminderListWindow = null;
    private Radiogroup radioGroup = null;
    private MToDoTeamReminder m_TeamToDoReminder = null;

    public PersonalToDoReminderListRowRenderer(PersonalToDoReminderListWindow personalToDoReminderListWindow, Radiogroup radioGroup) {
        this.personalToDoReminderListWindow = personalToDoReminderListWindow;
        this.m_TeamToDoReminder = personalToDoReminderListWindow.getMToDoTeamReminder();
        this.radioGroup = radioGroup;
    }

    public void render(Row row, PersonalToDoReminderModel data, int index) throws Exception {
        String string_Time;
        String string_Date;
        Date dateAndTime;
        Cell cell = new Cell();
        Radio radio = new Radio();
        radio.setRadiogroup(this.radioGroup);
        radio.setAttribute("JP_ToDo_Reminder_ID", (Object)data.JP_ToDo_Reminder_ID);
        radio.addEventListener("onCheck", (EventListener)this.personalToDoReminderListWindow);
        cell.appendChild((Component)radio);
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.appendChild((Component)new Label(data.user));
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.appendChild((Component)new Label(data.status));
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.setStyle("text-align:center;");
        Checkbox cb = new Checkbox();
        cb.setChecked(data.IsSentReminderJP);
        cb.setDisabled(true);
        cell.appendChild((Component)cb);
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.setStyle("text-align:center;");
        cb = new Checkbox();
        cb.setChecked(data.IsConfirmed);
        cb.setDisabled(true);
        cell.appendChild((Component)cb);
        row.appendChild((Component)cell);
        SimpleDateFormat sdfV = DisplayType.getDateFormat();
        cell = new Cell();
        if (data.JP_Confirmed != null) {
            dateAndTime = new Date(data.JP_Confirmed.getTime());
            string_Date = sdfV.format(dateAndTime);
            string_Time = data.JP_Confirmed.toLocalDateTime().toLocalTime().toString();
            cell.appendChild((Component)new Label(String.valueOf(string_Date) + " " + string_Time.substring(0, 5)));
        } else {
            cell.appendChild((Component)new Label(""));
        }
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.setStyle("text-align:center;");
        cb = new Checkbox();
        cb.setChecked(data.Processed);
        cb.setDisabled(true);
        cell.appendChild((Component)cb);
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.appendChild((Component)new Label(data.comments));
        row.appendChild((Component)cell);
        if (!"NO".equals(this.m_TeamToDoReminder.getJP_Mandatory_Statistics_Info())) {
            MColumn column;
            cell = new Cell();
            if ("YN".equals(this.m_TeamToDoReminder.getJP_Mandatory_Statistics_Info())) {
                if (Util.isEmpty((String)data.JP_Statistics_YesNo)) {
                    cell.appendChild((Component)new Label(""));
                } else {
                    int AD_Column_ID = MColumn.getColumn_ID((String)"JP_ToDo", (String)"JP_Statistics_YesNo");
                    column = MColumn.get((Properties)Env.getCtx(), (int)AD_Column_ID);
                    int reference_ID = column.getAD_Reference_Value_ID();
                    String statistics_info = MRefList.getListName((Properties)Env.getCtx(), (int)reference_ID, (String)data.JP_Statistics_YesNo);
                    cell.appendChild((Component)new Label(statistics_info));
                }
            } else if ("CC".equals(this.m_TeamToDoReminder.getJP_Mandatory_Statistics_Info())) {
                if (Util.isEmpty((String)data.JP_Statistics_Choice)) {
                    cell.appendChild((Component)new Label(""));
                } else {
                    int AD_Column_ID = MColumn.getColumn_ID((String)"JP_ToDo", (String)"JP_Statistics_Choice");
                    column = MColumn.get((Properties)Env.getCtx(), (int)AD_Column_ID);
                    int reference_ID = column.getAD_Reference_Value_ID();
                    String statistics_info = MRefList.getListName((Properties)Env.getCtx(), (int)reference_ID, (String)data.JP_Statistics_Choice);
                    cell.appendChild((Component)new Label(statistics_info));
                }
            } else if ("DT".equals(this.m_TeamToDoReminder.getJP_Mandatory_Statistics_Info())) {
                if (data.JP_Statistics_DateAndTime != null) {
                    dateAndTime = new Date(data.JP_Statistics_DateAndTime.getTime());
                    string_Date = sdfV.format(dateAndTime);
                    string_Time = data.JP_Statistics_DateAndTime.toLocalDateTime().toLocalTime().toString();
                    cell.appendChild((Component)new Label(String.valueOf(string_Date) + " " + string_Time.substring(0, 5)));
                }
            } else if ("NM".equals(this.m_TeamToDoReminder.getJP_Mandatory_Statistics_Info()) && data.JP_Statistics_Number != null) {
                cell.appendChild((Component)new Label(data.JP_Statistics_Number.toString()));
            }
            row.appendChild((Component)cell);
        }
    }
}

