/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.groupware.util;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import org.compiere.model.MUser;
import org.compiere.util.Util;

public class GroupwareTeamUtil {
    public static final String JP_REPETITION_INTERVAL_EVERYDAYS = "D";
    public static final String JP_REPETITION_INTERVAL_EVERYMONTHS = "M";
    public static final String JP_REPETITION_INTERVAL_EVERYWEEKS = "W";
    public static final String JP_REPETITION_INTERVAL_EVERYYEARS = "Y";

    public static HashMap<Integer, MUser> subtractionTeamMember(MUser[] user1, MUser[] user2) {
        HashMap<Integer, MUser> userMap = new HashMap<Integer, MUser>();
        int i = 0;
        while (i < user1.length) {
            boolean isSameUser = false;
            int j = 0;
            while (j < user2.length) {
                if (user1[i].getAD_User_ID() == user2[j].getAD_User_ID()) {
                    isSameUser = true;
                    break;
                }
                ++j;
            }
            if (!isSameUser) {
                userMap.put(user1[i].getAD_User_ID(), user1[i]);
            }
            ++i;
        }
        return userMap;
    }

    public static MUser[] addTeamMember(MUser[] user1, MUser[] user2) {
        HashMap<Integer, MUser> userMap = new HashMap<Integer, MUser>();
        int i = 0;
        while (i < user1.length) {
            userMap.put(user1[i].getAD_User_ID(), user1[i]);
            ++i;
        }
        i = 0;
        while (i < user2.length) {
            userMap.put(user2[i].getAD_User_ID(), user2[i]);
            ++i;
        }
        return userMap.values().toArray(new MUser[userMap.size()]);
    }

    public static Timestamp calculateNextScheduleTime(Timestamp timestamp, int offset, String JP_Repetition_Interval) {
        if (timestamp == null || offset == 0 || Util.isEmpty((String)JP_Repetition_Interval)) {
            return null;
        }
        LocalDateTime localDateTime = timestamp.toLocalDateTime();
        if (JP_REPETITION_INTERVAL_EVERYDAYS.equals(JP_Repetition_Interval)) {
            return Timestamp.valueOf(localDateTime.plusDays(offset));
        }
        if (JP_REPETITION_INTERVAL_EVERYWEEKS.equals(JP_Repetition_Interval)) {
            localDateTime = localDateTime.plusWeeks(offset);
            return Timestamp.valueOf(localDateTime);
        }
        if (JP_REPETITION_INTERVAL_EVERYMONTHS.equals(JP_Repetition_Interval)) {
            localDateTime = localDateTime.plusMonths(offset);
            return Timestamp.valueOf(localDateTime);
        }
        if (JP_REPETITION_INTERVAL_EVERYYEARS.equals(JP_Repetition_Interval)) {
            localDateTime = localDateTime.plusYears(offset);
            return Timestamp.valueOf(localDateTime);
        }
        return null;
    }
}

