/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang.ObjectUtils;

public final class StringUtils
extends org.apache.commons.lang.StringUtils {
    private static final String NUMERIC_CHARS = ".-0123456789\uff0e\uff0d\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19";
    private static final String NUMBER_CHARS = "0123456789\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19";
    public static final String REPLACE_WORD_HEADER = "${";
    public static final String REPLACE_WORD_FOOTER = "}";
    protected static final char QUOTE_SINGLE = '\'';
    protected static final char QUOTE_DOUBLE = '\"';
    public static final char QUOTE_SINGLE_ZENKAKU_BEGIN = '\u2018';
    public static final char QUOTE_SINGLE_ZENKAKU_END = '\u2019';
    public static final char QUOTE_DOUBLE_ZENKAKU_BEGIN = '\u201c';
    public static final char QUOTE_DOUBLE_ZENKAKU_END = '\u201d';
    public static final char[] QUOTE_SINGLES = new char[]{'\'', '\u2018', '\u2019'};
    public static final char[] QUOTE_DOUBLES = new char[]{'\"', '\u201c', '\u201d'};

    public static void replace(StringBuffer buffer, String pattern, String newPattern) {
        if (StringUtils.equals((String)pattern, (String)newPattern)) {
            return;
        }
        int patternLength = pattern.length();
        int idx = buffer.toString().indexOf(pattern);
        while (idx > -1) {
            buffer.replace(idx, idx + patternLength, newPattern);
            idx = buffer.toString().indexOf(pattern, idx + newPattern.length());
        }
    }

    public static void replace(StringBuffer buffer, char oldChar, char newChar) {
        int idx = buffer.toString().indexOf(oldChar);
        String newString = String.valueOf(newChar);
        while (idx > -1) {
            buffer.replace(idx, idx + 1, newString);
            idx = buffer.toString().indexOf(oldChar, idx + 1);
        }
    }

    public static String deleteNotNumeric(Object value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String str = String.valueOf(value);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (NUMERIC_CHARS.indexOf(c) > -1) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static boolean isNumeric(char c) {
        return NUMBER_CHARS.indexOf(c) > -1;
    }

    public static boolean hasNumeric(String string) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)string)) {
            return false;
        }
        int i = 0;
        while (i < string.length()) {
            if (NUMBER_CHARS.indexOf(string.charAt(i)) > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNumericOnly(String string) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)string)) {
            return false;
        }
        int i = 0;
        while (i < string.length()) {
            if (NUMBER_CHARS.indexOf(string.charAt(i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String deleteNotNumber(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (NUMBER_CHARS.indexOf(c) > -1) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String replaceWithProperties(String source, Properties properties) {
        return StringUtils.replaceWithProperties(source, properties, REPLACE_WORD_HEADER, REPLACE_WORD_FOOTER);
    }

    public static String replaceWithProperties(String source, Properties properties, String delimBegin, String delimEnd) {
        if (source == null) {
            return null;
        }
        if (org.apache.commons.lang.StringUtils.isEmpty((String)delimBegin) || org.apache.commons.lang.StringUtils.isEmpty((String)delimEnd)) {
            throw new UnsupportedOperationException("delimeter must be not null: '" + delimBegin + "' and '" + delimEnd + "'");
        }
        String key = StringUtils.extractString(source, delimBegin, delimEnd);
        while (key != null) {
            source = org.apache.commons.lang.StringUtils.replace((String)source, (String)(String.valueOf(delimBegin) + key + delimEnd), (String)properties.getProperty(key, ""));
            key = StringUtils.extractString(source, delimBegin, delimEnd);
        }
        return source;
    }

    public static String extractString(String source, String delimBegin, String delimEnd) {
        return StringUtils.extractString(source, delimBegin, delimEnd, 0);
    }

    public static String extractString(String source, String delimBegin, String delimEnd, int fromIndex) {
        int idxBegin = source.indexOf(delimBegin, fromIndex);
        if (idxBegin < 0) {
            return null;
        }
        int idxEnd = source.indexOf(delimEnd, idxBegin + 1);
        if (idxEnd < 0) {
            return null;
        }
        return source.substring(idxBegin + delimBegin.length(), idxEnd);
    }

    public static void extractStrings(String source, List dest, char delim) {
        StringUtils.extractStrings(source, dest, delim, delim, 0);
    }

    public static void extractStrings(String source, List dest, char delimBegin, char delimEnd) {
        StringUtils.extractStrings(source, dest, delimBegin, delimEnd, 0);
    }

    public static void extractStrings(String source, List dest, char delimBegin, char delimEnd, int fromIndex) {
        int idxBegin = source.indexOf(delimBegin, fromIndex);
        while (idxBegin > -1) {
            int idxEnd = source.indexOf(delimEnd, idxBegin + 1);
            if (idxEnd < 0) {
                return;
            }
            dest.add(source.substring(idxBegin + 1, idxEnd));
            idxBegin = source.indexOf(delimBegin, idxEnd + 1);
        }
    }

    public static String defaultString(Object value) {
        return StringUtils.defaultString(value, "");
    }

    public static String defaultString(Object value, String defaultValue) {
        return value == null ? defaultValue : value.toString();
    }

    public static String[] defaultStrings(Object[] values) {
        return StringUtils.defaultStrings(values, "");
    }

    public static String[] defaultStrings(Object[] values, String defaultValue) {
        if (values == null) {
            return null;
        }
        String[] result = new String[values.length];
        int i = 0;
        while (i < result.length) {
            result[i] = StringUtils.defaultString(values[i], defaultValue);
            ++i;
        }
        return result;
    }

    public static boolean compare(String target1, String target2) {
        return ObjectUtils.equals((Object)target1, (Object)target2);
    }

    public static List parseToList(String value, String delimiters) {
        Vector<String> result = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(value, delimiters, false);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static void tokenize(List dest, String str, String delim) {
        if (dest == null) {
            return;
        }
        if (StringUtils.isEmpty((String)str)) {
            return;
        }
        buf = new StringBuffer(str);
        idx = buf.indexOf(delim);
        if (idx >= 0) ** GOTO lbl16
        dest.add(str);
        return;
lbl-1000:
        // 1 sources

        {
            dest.add(buf.substring(0, idx));
            buf.delete(0, idx + delim.length());
            idx = buf.toString().indexOf(delim);
lbl16:
            // 2 sources

            ** while (idx > -1)
        }
lbl17:
        // 1 sources

        dest.add(buf.toString());
    }

    public static String[] tokenizeToArray(String str, String delim) {
        if (str == null) {
            return null;
        }
        ArrayList resultList = new ArrayList();
        StringUtils.tokenize(resultList, str, delim);
        if (resultList.size() < 1) {
            return new String[0];
        }
        String[] result = new String[resultList.size()];
        int i = 0;
        while (i < resultList.size()) {
            result[i] = (String)resultList.get(i);
            ++i;
        }
        return result;
    }

    public static List tokenize(String str, String delim) {
        ArrayList result = new ArrayList();
        StringUtils.tokenize(result, str, delim);
        return result;
    }

    public static int indexOf(char[] source, char value) {
        if (source == null) {
            return -1;
        }
        int i = 0;
        while (i < source.length) {
            if (source[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean containAnyChar(String s, char[] chars) {
        if (s == null) {
            return false;
        }
        if (chars == null) {
            return false;
        }
        int i = 0;
        while (i < chars.length) {
            int idx = s.indexOf(chars[i]);
            if (idx > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String duplicateQuote(String value, char[] quotes, boolean nullTrim) {
        if (nullTrim) {
            value = org.apache.commons.lang.StringUtils.defaultString((String)value);
        }
        if (value == null) {
            return null;
        }
        if (!StringUtils.containAnyChar(value, quotes)) {
            return value;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            result.append(c);
            if (StringUtils.indexOf(quotes, c) > -1) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String duplicateQuote(String value, char[] quotes) {
        return StringUtils.duplicateQuote(value, quotes, true);
    }

    public static String duplicateQuote(String value, char quote, boolean nullTrim) {
        return StringUtils.duplicateQuote(value, new char[]{quote}, nullTrim);
    }

    public static String duplicateQuote(String value, char quote) {
        return StringUtils.duplicateQuote(value, quote, true);
    }

    public static String toQuoted(String value, char quote, boolean nullTrim) {
        String result = StringUtils.duplicateQuote(value, quote, nullTrim);
        if (!nullTrim && result == null) {
            return null;
        }
        return StringUtils.addQuote(result, quote);
    }

    public static String toQuoted(String value, char quote) {
        return StringUtils.toQuoted(value, quote, true);
    }

    private static String addQuote(String value, char quote) {
        return String.valueOf(quote) + org.apache.commons.lang.StringUtils.defaultString((String)value) + quote;
    }

    public static String padHead(String value, String pad, int length) {
        if (value.getBytes().length >= length) {
            return value;
        }
        int addNum = (length - value.getBytes().length) / pad.getBytes().length;
        StringBuffer buffer = new StringBuffer(value);
        int index = 0;
        while (index < addNum) {
            buffer.insert(0, pad);
            ++index;
        }
        return buffer.toString();
    }

    public static String padTail(String value, String pad, int length) {
        if (value.getBytes().length >= length) {
            return value;
        }
        int addNum = (length - value.getBytes().length) / pad.getBytes().length;
        StringBuffer buffer = new StringBuffer(value);
        int index = 0;
        while (index < addNum) {
            buffer.append(pad);
            ++index;
        }
        return buffer.toString();
    }

    public static String getPackageAsPath(String packageName) {
        return StringUtils.getPackageAsPath(packageName, "/");
    }

    public static String getPackageAsPath(String packageName, String separater) {
        return org.apache.commons.lang.StringUtils.replace((String)packageName, (String)".", (String)separater);
    }

    public static String valueOf(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static String valueOf(byte value) {
        return String.valueOf(value);
    }

    public static String valueOf(short value) {
        return String.valueOf(value);
    }

    public static String valueOf(int value) {
        return String.valueOf(value);
    }

    public static String valueOf(long value) {
        return String.valueOf(value);
    }

    public static String valueOf(double value) {
        return String.valueOf(value);
    }

    public static String valueOf(float value) {
        return String.valueOf(value);
    }

    public static String valueOf(char value) {
        return String.valueOf(value);
    }

    public static String valueOf(boolean value) {
        return String.valueOf(value);
    }

    public static String joinIfValueNotNull(String value, String leftStr, String rightStr) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return String.valueOf(org.apache.commons.lang.StringUtils.defaultString((String)leftStr)) + value + org.apache.commons.lang.StringUtils.defaultString((String)rightStr);
    }
}

