/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.lang;

import org.asyrinx.brownie.core.lang.NumberUtils;

public class PropertyUtils
extends org.apache.commons.beanutils.PropertyUtils {
    public static String getPropertyAsString(Object object, String propName) {
        return PropertyUtils.getPropertyAsString(object, propName, null);
    }

    public static String getPropertyAsString(Object object, String propName, String defaultValue) {
        try {
            return String.valueOf(org.apache.commons.beanutils.PropertyUtils.getProperty((Object)object, (String)propName));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getPropertyAsInt(Object object, String propName) {
        return PropertyUtils.getPropertyAsInt(object, propName, 0);
    }

    public static int getPropertyAsInt(Object object, String propName, int defaultValue) {
        Object result;
        try {
            result = org.apache.commons.beanutils.PropertyUtils.getProperty((Object)object, (String)propName);
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        if (result instanceof String) {
            return NumberUtils.toInt(result, 0);
        }
        return defaultValue;
    }

    public static long getPropertyAsLong(Object object, String propName) {
        return PropertyUtils.getPropertyAsLong(object, propName, 0L);
    }

    public static long getPropertyAsLong(Object object, String propName, long defaultValue) {
        Object result;
        try {
            result = org.apache.commons.beanutils.PropertyUtils.getProperty((Object)object, (String)propName);
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).longValue();
        }
        if (result instanceof String) {
            return NumberUtils.toLong(result, 0L);
        }
        return defaultValue;
    }

    public static boolean getPropertyAsBoolean(Object object, String propName) {
        return PropertyUtils.getPropertyAsBoolean(object, propName, false);
    }

    public static boolean getPropertyAsBoolean(Object object, String propName, boolean defaultValue) {
        Object result;
        try {
            result = org.apache.commons.beanutils.PropertyUtils.getProperty((Object)object, (String)propName);
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            return "true".equalsIgnoreCase((String)result);
        }
        return defaultValue;
    }
}

