/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.csv;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.asyrinx.brownie.core.csv.SVBeanMapper;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.brownie.core.lang.enum.ValuedEnum;

public class PropertySVBeanMapper
implements SVBeanMapper {
    protected final Properties properties;
    protected final String mappedClassName;
    private DateFormat dateFormat = DateFormat.getDateInstance();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PropertySVBeanMapper(String mappedClassName, Properties properties) {
        this.properties = properties;
        this.mappedClassName = mappedClassName;
    }

    public PropertySVBeanMapper(String mappedClassName, String propertyContext) throws IOException {
        this(mappedClassName, PropertySVBeanMapper.loadProperties(propertyContext));
    }

    private static Properties loadProperties(String propertyContext) throws IOException {
        StreamFactoryFacade streamFactory = StreamFactoryFacade.newFacade();
        InputStream inputStream = streamFactory.newInput(propertyContext);
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }

    public Object loadBean(List values) {
        Object bean = this.getBean();
        this.loadPropertyValues(values, bean);
        return bean;
    }

    protected void loadPropertyValues(List values, Object bean) {
        Set<Object> keys = this.properties.keySet();
        HashMap valueMap = new HashMap();
        try {
            Iterator<Object> iter = keys.iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                String propName = String.valueOf(this.properties.get(key));
                int keyIndex = NumberUtils.toInt(key, -1);
                if (keyIndex < 0 || keyIndex > values.size() - 1) {
                    throw new NestableRuntimeException("\u4e0d\u6b63\u306akey\u3067\u3059: " + key);
                }
                Object value = values.get(keyIndex);
                value = this.loadPropertyObject(bean, propName, value);
                valueMap.put(propName, value);
            }
            BeanUtils.populate((Object)bean, valueMap);
        }
        catch (Exception e) {
            throw new NestableRuntimeException("bean: '" + bean + "', valueMap: " + valueMap, (Throwable)e);
        }
    }

    protected Object loadPropertyObject(Object bean, String propName, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ParseException, ClassNotFoundException {
        Class propType = PropertyUtils.getPropertyType((Object)bean, (String)propName);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(propType)) {
            value = this.dateFormat.parse(String.valueOf(value));
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.asyrinx.brownie.core.lang.enum.ValuedEnum");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.isAssignableFrom(propType)) {
                Class.forName(propType.getName());
                value = ValuedEnum.getEnumByName(propType, String.valueOf(value));
            }
        }
        return value;
    }

    protected Object getBean() {
        try {
            return ClassUtils.newObject(this.mappedClassName, null);
        }
        catch (InstantiationException e) {
            throw new NestableRuntimeException((Throwable)e);
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat format) {
        this.dateFormat = format;
    }
}

