/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing.table;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.asyrinx.brownie.swing.table.TableUtils;
import org.asyrinx.brownie.swing.table.util.InvisibleColumnTableModel;
import org.asyrinx.brownie.swing.table.util.SimpleSortableTableModel;

public class ListViewTable
extends JScrollPane {
    private JTable table = null;
    private DefaultTableModel model = null;
    private SimpleSortableTableModel sortableModel = null;
    private InvisibleColumnTableModel invisibleColumnModel = null;
    private int defaultPreferredColumnWidth = 150;

    public ListViewTable() {
        this.initialize();
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(32);
    }

    public ListViewTable(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.initialize();
    }

    public ListViewTable(Component view) {
        super(view);
        this.initialize();
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(32);
    }

    public ListViewTable(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.initialize();
    }

    protected void initialize() {
        this.setViewportView(this.getTable());
        this.setSize(252, 217);
    }

    public DefaultTableModel getModel() {
        return this.model;
    }

    public SimpleSortableTableModel getSortableModel() {
        return this.sortableModel;
    }

    public InvisibleColumnTableModel getInvisibleColumnModel() {
        return this.invisibleColumnModel;
    }

    public JTable getTable() {
        if (this.table == null) {
            this.table = new JTable();
            this.initTable(this.table);
        }
        return this.table;
    }

    protected void initTable(JTable target) {
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                JTableHeader header = ListViewTable.this.getTable().getTableHeader();
                int viewColIndex = header.columnAtPoint(e.getPoint());
                boolean reverse = e.getClickCount() % 2 == 0;
                ListViewTable.this.sortByViewColIndex(viewColIndex, reverse);
            }
        });
        this.model = new DefaultTableModel();
        this.initColumns();
        this.model.setRowCount(0);
        this.sortableModel = TableUtils.toSortableModel(this.model);
        this.invisibleColumnModel = TableUtils.toInvisibleColumnModel(this.sortableModel, this.getInvisibleColumnIndex(), this.getInvisibleColumnCount());
        target.setModel(TableUtils.toUneditableModel(this.invisibleColumnModel));
        target.setCellEditor(null);
        target.setEditingColumn(0);
        target.setColumnSelectionAllowed(false);
        target.setRowSelectionAllowed(true);
        target.setFocusable(true);
        target.setSelectionMode(0);
        target.setAutoResizeMode(0);
        this.initColumnWidth(target);
        this.initRowData();
    }

    protected void initRowData() {
    }

    private void initColumnWidth(JTable target) {
        int colCount = target.getTableHeader().getColumnModel().getColumnCount();
        TableColumnModel columnModel = target.getTableHeader().getColumnModel();
        int i = 0;
        while (i < colCount) {
            TableColumn column = columnModel.getColumn(i);
            column.setPreferredWidth(this.getDefaultPreferredColumnWidth());
            ++i;
        }
    }

    protected int getInvisibleColumnIndex() {
        return -1;
    }

    protected int getInvisibleColumnCount() {
        return 0;
    }

    protected void initColumns() {
    }

    public void sortByViewColIndex(int viewColIndex, boolean reverse) {
        int visibleModelColIndex = this.getTable().getTableHeader().getColumnModel().getColumn(viewColIndex).getModelIndex();
        this.sortByVisibleModelColIndex(visibleModelColIndex, reverse);
    }

    public void sortByVisibleModelColIndex(int visibleModelColIndex, boolean reverse) {
        int originalColIndex = this.getInvisibleColumnModel().getOriginalColumnIndex(visibleModelColIndex);
        this.sortByOriginalModelColIndex(originalColIndex, reverse);
    }

    public void sortByOriginalModelColIndex(int originalColIndex, boolean reverse) {
        this.getSortableModel().sort(originalColIndex, reverse);
        this.getTable().revalidate();
    }

    public void load(List entities) {
    }

    public int getDefaultPreferredColumnWidth() {
        return this.defaultPreferredColumnWidth;
    }

    public void setDefaultPreferredColumnWidth(int i) {
        this.defaultPreferredColumnWidth = i;
    }
}

